package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.FilterValue
import scala.jdk.CollectionConverters._
final case class ECSServiceRecommendationFilter(
    name: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName
    ] = Optional.Absent,
    values: Optional[Iterable[FilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter = {
    import ECSServiceRecommendationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter
      .wrap(buildAwsValue())
}
object ECSServiceRecommendationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter =
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName
    ]
    def values: Optional[List[FilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter
  ) extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter.ReadOnly {
    override val name: Optional[
      zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.computeoptimizer.model.ECSServiceRecommendationFilterName
          .wrap(value)
      )
    override val values: Optional[List[FilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter.ReadOnly =
    new Wrapper(impl)
}
