package zio.aws.computeoptimizer
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.computeoptimizer.model.primitives.FailureReason.Type
import zio.aws.computeoptimizer.model.primitives.{
  VolumeArn,
  InstanceArn,
  ServiceArn,
  AutoScalingGroupArn,
  AccountId,
  Timestamp,
  MetricValue,
  FunctionArn,
  JobId,
  ResourceArn,
  FilterValue
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.computeoptimizer.model.primitives.AccountId.Type
    object AutoScalingGroupArn extends Subtype[String]
    type AutoScalingGroupArn =
      zio.aws.computeoptimizer.model.primitives.AutoScalingGroupArn.Type
    object AutoScalingGroupName extends Subtype[String]
    type AutoScalingGroupName =
      zio.aws.computeoptimizer.model.primitives.AutoScalingGroupName.Type
    object Code extends Subtype[String]
    type Code = zio.aws.computeoptimizer.model.primitives.Code.Type
    object ContainerName extends Subtype[String]
    type ContainerName =
      zio.aws.computeoptimizer.model.primitives.ContainerName.Type
    object CpuSize extends Subtype[Int]
    type CpuSize = zio.aws.computeoptimizer.model.primitives.CpuSize.Type
    object CreationTimestamp extends Subtype[Instant]
    type CreationTimestamp =
      zio.aws.computeoptimizer.model.primitives.CreationTimestamp.Type
    object CurrentInstanceType extends Subtype[String]
    type CurrentInstanceType =
      zio.aws.computeoptimizer.model.primitives.CurrentInstanceType.Type
    object DesiredCapacity extends Subtype[Int]
    type DesiredCapacity =
      zio.aws.computeoptimizer.model.primitives.DesiredCapacity.Type
    object DestinationBucket extends Subtype[String]
    type DestinationBucket =
      zio.aws.computeoptimizer.model.primitives.DestinationBucket.Type
    object DestinationKey extends Subtype[String]
    type DestinationKey =
      zio.aws.computeoptimizer.model.primitives.DestinationKey.Type
    object DestinationKeyPrefix extends Subtype[String]
    type DestinationKeyPrefix =
      zio.aws.computeoptimizer.model.primitives.DestinationKeyPrefix.Type
    object ExternalMetricStatusReason extends Subtype[String]
    type ExternalMetricStatusReason =
      zio.aws.computeoptimizer.model.primitives.ExternalMetricStatusReason.Type
    object FailureReason extends Subtype[String]
    type FailureReason =
      zio.aws.computeoptimizer.model.primitives.FailureReason.Type
    object FilterValue extends Subtype[String]
    type FilterValue =
      zio.aws.computeoptimizer.model.primitives.FilterValue.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn =
      zio.aws.computeoptimizer.model.primitives.FunctionArn.Type
    object FunctionVersion extends Subtype[String]
    type FunctionVersion =
      zio.aws.computeoptimizer.model.primitives.FunctionVersion.Type
    object GpuCount extends Subtype[Int]
    type GpuCount = zio.aws.computeoptimizer.model.primitives.GpuCount.Type
    object GpuMemorySizeInMiB extends Subtype[Int]
    type GpuMemorySizeInMiB =
      zio.aws.computeoptimizer.model.primitives.GpuMemorySizeInMiB.Type
    object High extends Subtype[Long]
    type High = zio.aws.computeoptimizer.model.primitives.High.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.computeoptimizer.model.primitives.Identifier.Type
    object IncludeMemberAccounts extends Subtype[Boolean]
    type IncludeMemberAccounts =
      zio.aws.computeoptimizer.model.primitives.IncludeMemberAccounts.Type
    object InstanceArn extends Subtype[String]
    type InstanceArn =
      zio.aws.computeoptimizer.model.primitives.InstanceArn.Type
    object InstanceName extends Subtype[String]
    type InstanceName =
      zio.aws.computeoptimizer.model.primitives.InstanceName.Type
    object InstanceType extends Subtype[String]
    type InstanceType =
      zio.aws.computeoptimizer.model.primitives.InstanceType.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.computeoptimizer.model.primitives.JobId.Type
    object LastRefreshTimestamp extends Subtype[Instant]
    type LastRefreshTimestamp =
      zio.aws.computeoptimizer.model.primitives.LastRefreshTimestamp.Type
    object LastUpdatedTimestamp extends Subtype[Instant]
    type LastUpdatedTimestamp =
      zio.aws.computeoptimizer.model.primitives.LastUpdatedTimestamp.Type
    object LicenseVersion extends Subtype[String]
    type LicenseVersion =
      zio.aws.computeoptimizer.model.primitives.LicenseVersion.Type
    object LookBackPeriodInDays extends Subtype[Double]
    type LookBackPeriodInDays =
      zio.aws.computeoptimizer.model.primitives.LookBackPeriodInDays.Type
    object Low extends Subtype[Long]
    type Low = zio.aws.computeoptimizer.model.primitives.Low.Type
    object LowerBoundValue extends Subtype[Double]
    type LowerBoundValue =
      zio.aws.computeoptimizer.model.primitives.LowerBoundValue.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.computeoptimizer.model.primitives.MaxResults.Type
    object MaxSize extends Subtype[Int]
    type MaxSize = zio.aws.computeoptimizer.model.primitives.MaxSize.Type
    object Medium extends Subtype[Long]
    type Medium = zio.aws.computeoptimizer.model.primitives.Medium.Type
    object MemberAccountsEnrolled extends Subtype[Boolean]
    type MemberAccountsEnrolled =
      zio.aws.computeoptimizer.model.primitives.MemberAccountsEnrolled.Type
    object MemorySize extends Subtype[Int]
    type MemorySize = zio.aws.computeoptimizer.model.primitives.MemorySize.Type
    object Message extends Subtype[String]
    type Message = zio.aws.computeoptimizer.model.primitives.Message.Type
    object MetadataKey extends Subtype[String]
    type MetadataKey =
      zio.aws.computeoptimizer.model.primitives.MetadataKey.Type
    object MetricProviderArn extends Subtype[String]
    type MetricProviderArn =
      zio.aws.computeoptimizer.model.primitives.MetricProviderArn.Type
    object MetricValue extends Subtype[Double]
    type MetricValue =
      zio.aws.computeoptimizer.model.primitives.MetricValue.Type
    object MinSize extends Subtype[Int]
    type MinSize = zio.aws.computeoptimizer.model.primitives.MinSize.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.computeoptimizer.model.primitives.NextToken.Type
    object NullableCpu extends Subtype[Int]
    type NullableCpu =
      zio.aws.computeoptimizer.model.primitives.NullableCpu.Type
    object NullableMemory extends Subtype[Int]
    type NullableMemory =
      zio.aws.computeoptimizer.model.primitives.NullableMemory.Type
    object NullableMemoryReservation extends Subtype[Int]
    type NullableMemoryReservation =
      zio.aws.computeoptimizer.model.primitives.NullableMemoryReservation.Type
    object NumberOfCores extends Subtype[Int]
    type NumberOfCores =
      zio.aws.computeoptimizer.model.primitives.NumberOfCores.Type
    object NumberOfInvocations extends Subtype[Long]
    type NumberOfInvocations =
      zio.aws.computeoptimizer.model.primitives.NumberOfInvocations.Type
    object NumberOfMemberAccountsOptedIn extends Subtype[Int]
    type NumberOfMemberAccountsOptedIn =
      zio.aws.computeoptimizer.model.primitives.NumberOfMemberAccountsOptedIn.Type
    object OperatingSystem extends Subtype[String]
    type OperatingSystem =
      zio.aws.computeoptimizer.model.primitives.OperatingSystem.Type
    object PerformanceRisk extends Subtype[Double]
    type PerformanceRisk =
      zio.aws.computeoptimizer.model.primitives.PerformanceRisk.Type
    object Period extends Subtype[Int]
    type Period = zio.aws.computeoptimizer.model.primitives.Period.Type
    object Rank extends Subtype[Int]
    type Rank = zio.aws.computeoptimizer.model.primitives.Rank.Type
    object RecommendationSourceArn extends Subtype[String]
    type RecommendationSourceArn =
      zio.aws.computeoptimizer.model.primitives.RecommendationSourceArn.Type
    object RecommendedInstanceType extends Subtype[String]
    type RecommendedInstanceType =
      zio.aws.computeoptimizer.model.primitives.RecommendedInstanceType.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.computeoptimizer.model.primitives.ResourceArn.Type
    object RootVolume extends Subtype[Boolean]
    type RootVolume = zio.aws.computeoptimizer.model.primitives.RootVolume.Type
    object SavingsOpportunityPercentage extends Subtype[Double]
    type SavingsOpportunityPercentage =
      zio.aws.computeoptimizer.model.primitives.SavingsOpportunityPercentage.Type
    object ScopeValue extends Subtype[String]
    type ScopeValue = zio.aws.computeoptimizer.model.primitives.ScopeValue.Type
    object ServiceArn extends Subtype[String]
    type ServiceArn = zio.aws.computeoptimizer.model.primitives.ServiceArn.Type
    object StatusReason extends Subtype[String]
    type StatusReason =
      zio.aws.computeoptimizer.model.primitives.StatusReason.Type
    object SummaryValue extends Subtype[Double]
    type SummaryValue =
      zio.aws.computeoptimizer.model.primitives.SummaryValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.computeoptimizer.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.computeoptimizer.model.primitives.TagValue.Type
    object TaskDefinitionArn extends Subtype[String]
    type TaskDefinitionArn =
      zio.aws.computeoptimizer.model.primitives.TaskDefinitionArn.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.computeoptimizer.model.primitives.Timestamp.Type
    object UpperBoundValue extends Subtype[Double]
    type UpperBoundValue =
      zio.aws.computeoptimizer.model.primitives.UpperBoundValue.Type
    object Value extends Subtype[Double]
    type Value = zio.aws.computeoptimizer.model.primitives.Value.Type
    object VeryLow extends Subtype[Long]
    type VeryLow = zio.aws.computeoptimizer.model.primitives.VeryLow.Type
    object VolumeArn extends Subtype[String]
    type VolumeArn = zio.aws.computeoptimizer.model.primitives.VolumeArn.Type
    object VolumeBaselineIOPS extends Subtype[Int]
    type VolumeBaselineIOPS =
      zio.aws.computeoptimizer.model.primitives.VolumeBaselineIOPS.Type
    object VolumeBaselineThroughput extends Subtype[Int]
    type VolumeBaselineThroughput =
      zio.aws.computeoptimizer.model.primitives.VolumeBaselineThroughput.Type
    object VolumeBurstIOPS extends Subtype[Int]
    type VolumeBurstIOPS =
      zio.aws.computeoptimizer.model.primitives.VolumeBurstIOPS.Type
    object VolumeBurstThroughput extends Subtype[Int]
    type VolumeBurstThroughput =
      zio.aws.computeoptimizer.model.primitives.VolumeBurstThroughput.Type
    object VolumeSize extends Subtype[Int]
    type VolumeSize = zio.aws.computeoptimizer.model.primitives.VolumeSize.Type
    object VolumeType extends Subtype[String]
    type VolumeType = zio.aws.computeoptimizer.model.primitives.VolumeType.Type
  }
  type AccountEnrollmentStatuses =
    List[zio.aws.computeoptimizer.model.AccountEnrollmentStatus]
  type AccountIds = List[AccountId]
  type AutoScalingGroupArns = List[AutoScalingGroupArn]
  type AutoScalingGroupRecommendationOptions =
    List[zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption]
  type AutoScalingGroupRecommendations =
    List[zio.aws.computeoptimizer.model.AutoScalingGroupRecommendation]
  type ContainerConfigurations =
    List[zio.aws.computeoptimizer.model.ContainerConfiguration]
  type ContainerRecommendations =
    List[zio.aws.computeoptimizer.model.ContainerRecommendation]
  type CpuVendorArchitectures =
    List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]
  type EBSFilters = List[zio.aws.computeoptimizer.model.EBSFilter]
  type EBSUtilizationMetrics =
    List[zio.aws.computeoptimizer.model.EBSUtilizationMetric]
  type ECSServiceProjectedMetrics =
    List[zio.aws.computeoptimizer.model.ECSServiceProjectedMetric]
  type ECSServiceProjectedUtilizationMetrics =
    List[zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric]
  type ECSServiceRecommendationFilters =
    List[zio.aws.computeoptimizer.model.ECSServiceRecommendationFilter]
  type ECSServiceRecommendationFindingReasonCodes = List[
    zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
  ]
  type ECSServiceRecommendationOptions =
    List[zio.aws.computeoptimizer.model.ECSServiceRecommendationOption]
  type ECSServiceRecommendations =
    List[zio.aws.computeoptimizer.model.ECSServiceRecommendation]
  type ECSServiceRecommendedOptionProjectedMetrics = List[
    zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
  ]
  type ECSServiceUtilizationMetrics =
    List[zio.aws.computeoptimizer.model.ECSServiceUtilizationMetric]
  type EnrollmentFilters = List[zio.aws.computeoptimizer.model.EnrollmentFilter]
  type ExportableAutoScalingGroupFields =
    List[zio.aws.computeoptimizer.model.ExportableAutoScalingGroupField]
  type ExportableECSServiceFields =
    List[zio.aws.computeoptimizer.model.ExportableECSServiceField]
  type ExportableInstanceFields =
    List[zio.aws.computeoptimizer.model.ExportableInstanceField]
  type ExportableLambdaFunctionFields =
    List[zio.aws.computeoptimizer.model.ExportableLambdaFunctionField]
  type ExportableLicenseFields =
    List[zio.aws.computeoptimizer.model.ExportableLicenseField]
  type ExportableVolumeFields =
    List[zio.aws.computeoptimizer.model.ExportableVolumeField]
  type FilterValues = List[FilterValue]
  type Filters = List[zio.aws.computeoptimizer.model.Filter]
  type FunctionArns = List[FunctionArn]
  type GetRecommendationErrors =
    List[zio.aws.computeoptimizer.model.GetRecommendationError]
  type Gpus = List[zio.aws.computeoptimizer.model.Gpu]
  type InferredWorkloadSavings =
    List[zio.aws.computeoptimizer.model.InferredWorkloadSaving]
  type InferredWorkloadTypes =
    List[zio.aws.computeoptimizer.model.InferredWorkloadType]
  type InstanceArns = List[InstanceArn]
  type InstanceRecommendationFindingReasonCodes =
    List[zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode]
  type InstanceRecommendations =
    List[zio.aws.computeoptimizer.model.InstanceRecommendation]
  type JobFilters = List[zio.aws.computeoptimizer.model.JobFilter]
  type JobIds = List[JobId]
  type LambdaFunctionMemoryProjectedMetrics =
    List[zio.aws.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric]
  type LambdaFunctionMemoryRecommendationOptions = List[
    zio.aws.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption
  ]
  type LambdaFunctionRecommendationFilters =
    List[zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFilter]
  type LambdaFunctionRecommendationFindingReasonCodes = List[
    zio.aws.computeoptimizer.model.LambdaFunctionRecommendationFindingReasonCode
  ]
  type LambdaFunctionRecommendations =
    List[zio.aws.computeoptimizer.model.LambdaFunctionRecommendation]
  type LambdaFunctionUtilizationMetrics =
    List[zio.aws.computeoptimizer.model.LambdaFunctionUtilizationMetric]
  type LicenseFindingReasonCodes =
    List[zio.aws.computeoptimizer.model.LicenseFindingReasonCode]
  type LicenseRecommendationFilters =
    List[zio.aws.computeoptimizer.model.LicenseRecommendationFilter]
  type LicenseRecommendationOptions =
    List[zio.aws.computeoptimizer.model.LicenseRecommendationOption]
  type LicenseRecommendations =
    List[zio.aws.computeoptimizer.model.LicenseRecommendation]
  type MetricValues = List[MetricValue]
  type MetricsSource = List[zio.aws.computeoptimizer.model.MetricSource]
  type PlatformDifferences =
    List[zio.aws.computeoptimizer.model.PlatformDifference]
  type ProjectedMetrics = List[zio.aws.computeoptimizer.model.ProjectedMetric]
  type ProjectedUtilizationMetrics =
    List[zio.aws.computeoptimizer.model.UtilizationMetric]
  type ReasonCodeSummaries =
    List[zio.aws.computeoptimizer.model.ReasonCodeSummary]
  type RecommendationExportJobs =
    List[zio.aws.computeoptimizer.model.RecommendationExportJob]
  type RecommendationOptions =
    List[zio.aws.computeoptimizer.model.InstanceRecommendationOption]
  type RecommendationPreferenceNames =
    List[zio.aws.computeoptimizer.model.RecommendationPreferenceName]
  type RecommendationPreferencesDetails =
    List[zio.aws.computeoptimizer.model.RecommendationPreferencesDetail]
  type RecommendationSources =
    List[zio.aws.computeoptimizer.model.RecommendationSource]
  type RecommendationSummaries =
    List[zio.aws.computeoptimizer.model.RecommendationSummary]
  type RecommendedOptionProjectedMetrics =
    List[zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric]
  type ResourceArns = List[ResourceArn]
  type ServiceArns = List[ServiceArn]
  type Summaries = List[zio.aws.computeoptimizer.model.Summary]
  type Tags = List[zio.aws.computeoptimizer.model.Tag]
  type Timestamps = List[Timestamp]
  type UtilizationMetrics =
    List[zio.aws.computeoptimizer.model.UtilizationMetric]
  type VolumeArns = List[VolumeArn]
  type VolumeRecommendationOptions =
    List[zio.aws.computeoptimizer.model.VolumeRecommendationOption]
  type VolumeRecommendations =
    List[zio.aws.computeoptimizer.model.VolumeRecommendation]
}
