package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait FindingReasonCode {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode
}
object FindingReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode
  ): zio.aws.computeoptimizer.model.FindingReasonCode = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.MEMORY_OVERPROVISIONED =>
      val r = MemoryOverprovisioned
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.MEMORY_UNDERPROVISIONED =>
      val r = MemoryUnderprovisioned
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.FindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object MemoryOverprovisioned
      extends zio.aws.computeoptimizer.model.FindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.MEMORY_OVERPROVISIONED
  }
  case object MemoryUnderprovisioned
      extends zio.aws.computeoptimizer.model.FindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.FindingReasonCode.MEMORY_UNDERPROVISIONED
  }
}
