package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationSourceType {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType
}
object RecommendationSourceType {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType
  ): zio.aws.computeoptimizer.model.RecommendationSourceType = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.EC2_INSTANCE =>
      val r = Ec2Instance
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.AUTO_SCALING_GROUP =>
      val r = AutoScalingGroup
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.EBS_VOLUME =>
      val r = EbsVolume
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.LAMBDA_FUNCTION =>
      val r = LambdaFunction
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.ECS_SERVICE =>
      val r = EcsService
      r
    case software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.LICENSE =>
      val r = License
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Ec2Instance
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.EC2_INSTANCE
  }
  case object AutoScalingGroup
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.AUTO_SCALING_GROUP
  }
  case object EbsVolume
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.EBS_VOLUME
  }
  case object LambdaFunction
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.LAMBDA_FUNCTION
  }
  case object EcsService
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.ECS_SERVICE
  }
  case object License
      extends zio.aws.computeoptimizer.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType =
      software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType.LICENSE
  }
}
