package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MemorySize, CpuSize}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ECSServiceRecommendedOptionProjectedMetric(
    recommendedCpuUnits: Optional[CpuSize] = Optional.Absent,
    recommendedMemorySize: Optional[MemorySize] = Optional.Absent,
    projectedMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.ECSServiceProjectedMetric]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric = {
    import ECSServiceRecommendedOptionProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
      .builder()
      .optionallyWith(
        recommendedCpuUnits.map(value => CpuSize.unwrap(value): Integer)
      )(_.recommendedCpuUnits)
      .optionallyWith(
        recommendedMemorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.recommendedMemorySize)
      .optionallyWith(
        projectedMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
      .wrap(buildAwsValue())
}
object ECSServiceRecommendedOptionProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric =
      zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric(
        recommendedCpuUnits.map(value => value),
        recommendedMemorySize.map(value => value),
        projectedMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recommendedCpuUnits: Optional[CpuSize]
    def recommendedMemorySize: Optional[MemorySize]
    def projectedMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly]
    ]
    def getRecommendedCpuUnits: ZIO[Any, AwsError, CpuSize] =
      AwsError.unwrapOptionField("recommendedCpuUnits", recommendedCpuUnits)
    def getRecommendedMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("recommendedMemorySize", recommendedMemorySize)
    def getProjectedMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("projectedMetrics", projectedMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
  ) extends zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly {
    override val recommendedCpuUnits: Optional[CpuSize] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendedCpuUnits())
      .map(value => zio.aws.computeoptimizer.model.primitives.CpuSize(value))
    override val recommendedMemorySize: Optional[MemorySize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendedMemorySize())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.MemorySize(value)
        )
    override val projectedMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceProjectedMetric.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendedOptionProjectedMetric.ReadOnly =
    new Wrapper(impl)
}
