package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{NullableCpu, NullableMemory}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ECSServiceRecommendationOption(
    memory: Optional[NullableMemory] = Optional.Absent,
    cpu: Optional[NullableCpu] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent,
    projectedUtilizationMetrics: Optional[Iterable[
      zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
    ]] = Optional.Absent,
    containerRecommendations: Optional[
      Iterable[zio.aws.computeoptimizer.model.ContainerRecommendation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption = {
    import ECSServiceRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption
      .builder()
      .optionallyWith(
        memory.map(value => NullableMemory.unwrap(value): Integer)
      )(_.memory)
      .optionallyWith(cpu.map(value => NullableCpu.unwrap(value): Integer))(
        _.cpu
      )
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(
        containerRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerRecommendations)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceRecommendationOption
      .wrap(buildAwsValue())
}
object ECSServiceRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ECSServiceRecommendationOption =
      zio.aws.computeoptimizer.model.ECSServiceRecommendationOption(
        memory.map(value => value),
        cpu.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containerRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def memory: Optional[NullableMemory]
    def cpu: Optional[NullableCpu]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def projectedUtilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly
    ]]
    def containerRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.ContainerRecommendation.ReadOnly]
    ]
    def getMemory: ZIO[Any, AwsError, NullableMemory] =
      AwsError.unwrapOptionField("memory", memory)
    def getCpu: ZIO[Any, AwsError, NullableCpu] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getContainerRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ContainerRecommendation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "containerRecommendations",
      containerRecommendations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption
  ) extends zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly {
    override val memory: Optional[NullableMemory] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableMemory(value)
      )
    override val cpu: Optional[NullableCpu] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableCpu(value)
      )
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val projectedUtilizationMetrics: Optional[List[
      zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
            .wrap(item)
        }.toList
      )
    override val containerRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.ContainerRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containerRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ContainerRecommendation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
