package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait LicenseEdition {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition
}
object LicenseEdition {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition
  ): zio.aws.computeoptimizer.model.LicenseEdition = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.ENTERPRISE =>
      val r = Enterprise
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.FREE =>
      val r = Free
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.NO_LICENSE_EDITION_FOUND =>
      val r = NoLicenseEditionFound
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseEdition {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.UNKNOWN_TO_SDK_VERSION
  }
  case object Enterprise extends zio.aws.computeoptimizer.model.LicenseEdition {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.ENTERPRISE
  }
  case object Standard extends zio.aws.computeoptimizer.model.LicenseEdition {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.STANDARD
  }
  case object Free extends zio.aws.computeoptimizer.model.LicenseEdition {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.FREE
  }
  case object NoLicenseEditionFound
      extends zio.aws.computeoptimizer.model.LicenseEdition {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition.NO_LICENSE_EDITION_FOUND
  }
}
