package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationExportJobsResponse(
    recommendationExportJobs: Optional[
      Iterable[zio.aws.computeoptimizer.model.RecommendationExportJob]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse = {
    import DescribeRecommendationExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
      .builder()
      .optionallyWith(
        recommendationExportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationExportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse
      .wrap(buildAwsValue())
}
object DescribeRecommendationExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse =
      zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse(
        recommendationExportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendationExportJobs: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getRecommendationExportJobs: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationExportJobs",
      recommendationExportJobs
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ) extends zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly {
    override val recommendationExportJobs: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationExportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationExportJob.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse
  ): zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
