package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{OperatingSystem, Rank}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LicenseRecommendationOption(
    rank: Optional[Rank] = Optional.Absent,
    operatingSystem: Optional[OperatingSystem] = Optional.Absent,
    licenseEdition: Optional[zio.aws.computeoptimizer.model.LicenseEdition] =
      Optional.Absent,
    licenseModel: Optional[zio.aws.computeoptimizer.model.LicenseModel] =
      Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption = {
    import LicenseRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption
      .builder()
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(
        operatingSystem.map(value =>
          OperatingSystem.unwrap(value): java.lang.String
        )
      )(_.operatingSystem)
      .optionallyWith(licenseEdition.map(value => value.unwrap))(
        _.licenseEdition
      )
      .optionallyWith(licenseModel.map(value => value.unwrap))(_.licenseModel)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.LicenseRecommendationOption
      .wrap(buildAwsValue())
}
object LicenseRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.LicenseRecommendationOption =
      zio.aws.computeoptimizer.model.LicenseRecommendationOption(
        rank.map(value => value),
        operatingSystem.map(value => value),
        licenseEdition.map(value => value),
        licenseModel.map(value => value),
        savingsOpportunity.map(value => value.asEditable)
      )
    def rank: Optional[Rank]
    def operatingSystem: Optional[OperatingSystem]
    def licenseEdition: Optional[zio.aws.computeoptimizer.model.LicenseEdition]
    def licenseModel: Optional[zio.aws.computeoptimizer.model.LicenseModel]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getOperatingSystem: ZIO[Any, AwsError, OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getLicenseEdition
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseEdition] =
      AwsError.unwrapOptionField("licenseEdition", licenseEdition)
    def getLicenseModel
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.LicenseModel] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption
  ) extends zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly {
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val operatingSystem: Optional[OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.OperatingSystem(value)
        )
    override val licenseEdition
        : Optional[zio.aws.computeoptimizer.model.LicenseEdition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseEdition())
        .map(value => zio.aws.computeoptimizer.model.LicenseEdition.wrap(value))
    override val licenseModel
        : Optional[zio.aws.computeoptimizer.model.LicenseModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseModel())
        .map(value => zio.aws.computeoptimizer.model.LicenseModel.wrap(value))
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationOption
  ): zio.aws.computeoptimizer.model.LicenseRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
