package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait LicenseModel {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.LicenseModel
}
object LicenseModel {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.LicenseModel
  ): zio.aws.computeoptimizer.model.LicenseModel = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.LICENSE_INCLUDED =>
      val r = LicenseIncluded
      r
    case software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.BRING_YOUR_OWN_LICENSE =>
      val r = BringYourOwnLicense
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.LicenseModel {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseModel =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.UNKNOWN_TO_SDK_VERSION
  }
  case object LicenseIncluded
      extends zio.aws.computeoptimizer.model.LicenseModel {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseModel =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.LICENSE_INCLUDED
  }
  case object BringYourOwnLicense
      extends zio.aws.computeoptimizer.model.LicenseModel {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.LicenseModel =
      software.amazon.awssdk.services.computeoptimizer.model.LicenseModel.BRING_YOUR_OWN_LICENSE
  }
}
