package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class RecommendationSummary(
    summaries: Optional[Iterable[zio.aws.computeoptimizer.model.Summary]] =
      Optional.Absent,
    recommendationResourceType: Optional[
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent,
    currentPerformanceRiskRatings: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings
    ] = Optional.Absent,
    inferredWorkloadSavings: Optional[
      Iterable[zio.aws.computeoptimizer.model.InferredWorkloadSaving]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary = {
    import RecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(recommendationResourceType.map(value => value.unwrap))(
        _.recommendationResourceType
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(
        currentPerformanceRiskRatings.map(value => value.buildAwsValue())
      )(_.currentPerformanceRiskRatings)
      .optionallyWith(
        inferredWorkloadSavings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferredWorkloadSavings)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendationSummary.wrap(buildAwsValue())
}
object RecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.RecommendationSummary =
      zio.aws.computeoptimizer.model.RecommendationSummary(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationResourceType.map(value => value),
        accountId.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        currentPerformanceRiskRatings.map(value => value.asEditable),
        inferredWorkloadSavings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def summaries
        : Optional[List[zio.aws.computeoptimizer.model.Summary.ReadOnly]]
    def recommendationResourceType
        : Optional[zio.aws.computeoptimizer.model.RecommendationSourceType]
    def accountId: Optional[AccountId]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def currentPerformanceRiskRatings: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ]
    def inferredWorkloadSavings: Optional[
      List[zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly]
    ]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Summary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getRecommendationResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationSourceType
    ] = AwsError.unwrapOptionField(
      "recommendationResourceType",
      recommendationResourceType
    )
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getCurrentPerformanceRiskRatings: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentPerformanceRiskRatings",
      currentPerformanceRiskRatings
    )
    def getInferredWorkloadSavings: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferredWorkloadSavings",
      inferredWorkloadSavings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ) extends zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly {
    override val summaries
        : Optional[List[zio.aws.computeoptimizer.model.Summary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Summary.wrap(item)
          }.toList
        )
    override val recommendationResourceType
        : Optional[zio.aws.computeoptimizer.model.RecommendationSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationResourceType())
        .map(value =>
          zio.aws.computeoptimizer.model.RecommendationSourceType.wrap(value)
        )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val currentPerformanceRiskRatings: Optional[
      zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentPerformanceRiskRatings())
      .map(value =>
        zio.aws.computeoptimizer.model.CurrentPerformanceRiskRatings.wrap(value)
      )
    override val inferredWorkloadSavings: Optional[
      List[zio.aws.computeoptimizer.model.InferredWorkloadSaving.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferredWorkloadSavings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.InferredWorkloadSaving.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary
  ): zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly =
    new Wrapper(impl)
}
