package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait InstanceState {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.InstanceState
}
object InstanceState {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.InstanceState
  ): zio.aws.computeoptimizer.model.InstanceState = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.RUNNING =>
      val r = running
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.SHUTTING_DOWN =>
      val r = `shutting-down`
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.TERMINATED =>
      val r = terminated
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.computeoptimizer.model.InstanceState.STOPPED =>
      val r = stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.PENDING
  }
  case object running extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.RUNNING
  }
  case object `shutting-down`
      extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.SHUTTING_DOWN
  }
  case object terminated extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.TERMINATED
  }
  case object stopping extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.STOPPING
  }
  case object stopped extends zio.aws.computeoptimizer.model.InstanceState {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceState =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceState.STOPPED
  }
}
