package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ScopeName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ScopeName
}
object ScopeName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ScopeName
  ): zio.aws.computeoptimizer.model.ScopeName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ScopeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ScopeName.ORGANIZATION =>
      val r = Organization
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ScopeName.ACCOUNT_ID =>
      val r = AccountId
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ScopeName.RESOURCE_ARN =>
      val r = ResourceArn
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ScopeName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ScopeName =
      software.amazon.awssdk.services.computeoptimizer.model.ScopeName.UNKNOWN_TO_SDK_VERSION
  }
  case object Organization extends zio.aws.computeoptimizer.model.ScopeName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ScopeName =
      software.amazon.awssdk.services.computeoptimizer.model.ScopeName.ORGANIZATION
  }
  case object AccountId extends zio.aws.computeoptimizer.model.ScopeName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ScopeName =
      software.amazon.awssdk.services.computeoptimizer.model.ScopeName.ACCOUNT_ID
  }
  case object ResourceArn extends zio.aws.computeoptimizer.model.ScopeName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ScopeName =
      software.amazon.awssdk.services.computeoptimizer.model.ScopeName.RESOURCE_ARN
  }
}
