package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{NullableCpu, ContainerName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ContainerConfiguration(
    containerName: Optional[ContainerName] = Optional.Absent,
    memorySizeConfiguration: Optional[
      zio.aws.computeoptimizer.model.MemorySizeConfiguration
    ] = Optional.Absent,
    cpu: Optional[NullableCpu] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration = {
    import ContainerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration
      .builder()
      .optionallyWith(
        containerName.map(value =>
          ContainerName.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(
        memorySizeConfiguration.map(value => value.buildAwsValue())
      )(_.memorySizeConfiguration)
      .optionallyWith(cpu.map(value => NullableCpu.unwrap(value): Integer))(
        _.cpu
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.ContainerConfiguration.wrap(buildAwsValue())
}
object ContainerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ContainerConfiguration =
      zio.aws.computeoptimizer.model.ContainerConfiguration(
        containerName.map(value => value),
        memorySizeConfiguration.map(value => value.asEditable),
        cpu.map(value => value)
      )
    def containerName: Optional[ContainerName]
    def memorySizeConfiguration: Optional[
      zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly
    ]
    def cpu: Optional[NullableCpu]
    def getContainerName: ZIO[Any, AwsError, ContainerName] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getMemorySizeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "memorySizeConfiguration",
      memorySizeConfiguration
    )
    def getCpu: ZIO[Any, AwsError, NullableCpu] =
      AwsError.unwrapOptionField("cpu", cpu)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration
  ) extends zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly {
    override val containerName: Optional[ContainerName] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.ContainerName(value)
      )
    override val memorySizeConfiguration: Optional[
      zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySizeConfiguration())
      .map(value =>
        zio.aws.computeoptimizer.model.MemorySizeConfiguration.wrap(value)
      )
    override val cpu: Optional[NullableCpu] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableCpu(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration
  ): zio.aws.computeoptimizer.model.ContainerConfiguration.ReadOnly =
    new Wrapper(impl)
}
