package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  NullableMemoryReservation,
  NullableMemory
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MemorySizeConfiguration(
    memory: Optional[NullableMemory] = Optional.Absent,
    memoryReservation: Optional[NullableMemoryReservation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration = {
    import MemorySizeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration
      .builder()
      .optionallyWith(
        memory.map(value => NullableMemory.unwrap(value): Integer)
      )(_.memory)
      .optionallyWith(
        memoryReservation.map(value =>
          NullableMemoryReservation.unwrap(value): Integer
        )
      )(_.memoryReservation)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly =
    zio.aws.computeoptimizer.model.MemorySizeConfiguration.wrap(buildAwsValue())
}
object MemorySizeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.MemorySizeConfiguration =
      zio.aws.computeoptimizer.model.MemorySizeConfiguration(
        memory.map(value => value),
        memoryReservation.map(value => value)
      )
    def memory: Optional[NullableMemory]
    def memoryReservation: Optional[NullableMemoryReservation]
    def getMemory: ZIO[Any, AwsError, NullableMemory] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, NullableMemoryReservation] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration
  ) extends zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly {
    override val memory: Optional[NullableMemory] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.NullableMemory(value)
      )
    override val memoryReservation: Optional[NullableMemoryReservation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryReservation())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .NullableMemoryReservation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration
  ): zio.aws.computeoptimizer.model.MemorySizeConfiguration.ReadOnly =
    new Wrapper(impl)
}
