package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ECSServiceRecommendationFindingReasonCode {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
}
object ECSServiceRecommendationFindingReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.MEMORY_OVERPROVISIONED =>
        val r = MemoryOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.MEMORY_UNDERPROVISIONED =>
        val r = MemoryUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.CPU_OVERPROVISIONED =>
        val r = CPUOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.CPU_UNDERPROVISIONED =>
        val r = CPUUnderprovisioned
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object MemoryOverprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.MEMORY_OVERPROVISIONED
  }
  case object MemoryUnderprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.MEMORY_UNDERPROVISIONED
  }
  case object CPUOverprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.CPU_OVERPROVISIONED
  }
  case object CPUUnderprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode.CPU_UNDERPROVISIONED
  }
}
