package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.{
  UpperBoundValue,
  LowerBoundValue
}
import scala.jdk.CollectionConverters._
final case class ECSServiceProjectedUtilizationMetric(
    name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      Optional.Absent,
    statistic: Optional[
      zio.aws.computeoptimizer.model.ECSServiceMetricStatistic
    ] = Optional.Absent,
    lowerBoundValue: Optional[LowerBoundValue] = Optional.Absent,
    upperBoundValue: Optional[UpperBoundValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric = {
    import ECSServiceProjectedUtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        lowerBoundValue.map(value =>
          LowerBoundValue.unwrap(value): java.lang.Double
        )
      )(_.lowerBoundValue)
      .optionallyWith(
        upperBoundValue.map(value =>
          UpperBoundValue.unwrap(value): java.lang.Double
        )
      )(_.upperBoundValue)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
      .wrap(buildAwsValue())
}
object ECSServiceProjectedUtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric =
      zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        lowerBoundValue.map(value => value),
        upperBoundValue.map(value => value)
      )
    def name: Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName]
    def statistic
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricStatistic]
    def lowerBoundValue: Optional[LowerBoundValue]
    def upperBoundValue: Optional[UpperBoundValue]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceMetricName
    ] = AwsError.unwrapOptionField("name", name)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ECSServiceMetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getLowerBoundValue: ZIO[Any, AwsError, LowerBoundValue] =
      AwsError.unwrapOptionField("lowerBoundValue", lowerBoundValue)
    def getUpperBoundValue: ZIO[Any, AwsError, UpperBoundValue] =
      AwsError.unwrapOptionField("upperBoundValue", upperBoundValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
  ) extends zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly {
    override val name
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceMetricName.wrap(value)
        )
    override val statistic
        : Optional[zio.aws.computeoptimizer.model.ECSServiceMetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.computeoptimizer.model.ECSServiceMetricStatistic.wrap(value)
        )
    override val lowerBoundValue: Optional[LowerBoundValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lowerBoundValue())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LowerBoundValue(value)
        )
    override val upperBoundValue: Optional[UpperBoundValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upperBoundValue())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.UpperBoundValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric
  ): zio.aws.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.ReadOnly =
    new Wrapper(impl)
}
