package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait CpuVendorArchitecture {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture
}
object CpuVendorArchitecture {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture
  ): zio.aws.computeoptimizer.model.CpuVendorArchitecture = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.AWS_ARM64 =>
      val r = AWS_ARM64
      r
    case software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.CURRENT =>
      val r = CURRENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.CpuVendorArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture =
      software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_ARM64
      extends zio.aws.computeoptimizer.model.CpuVendorArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture =
      software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.AWS_ARM64
  }
  case object CURRENT
      extends zio.aws.computeoptimizer.model.CpuVendorArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture =
      software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture.CURRENT
  }
}
