package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExportableVolumeField {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField
}
object ExportableVolumeField {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField
  ): zio.aws.computeoptimizer.model.ExportableVolumeField = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.ACCOUNT_ID =>
      val r = AccountId
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.VOLUME_ARN =>
      val r = VolumeArn
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.FINDING =>
      val r = Finding
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_READ_OPS_PER_SECOND_MAXIMUM =>
      val r = UtilizationMetricsVolumeReadOpsPerSecondMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_WRITE_OPS_PER_SECOND_MAXIMUM =>
      val r = UtilizationMetricsVolumeWriteOpsPerSecondMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_READ_BYTES_PER_SECOND_MAXIMUM =>
      val r = UtilizationMetricsVolumeReadBytesPerSecondMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_WRITE_BYTES_PER_SECOND_MAXIMUM =>
      val r = UtilizationMetricsVolumeWriteBytesPerSecondMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.LOOKBACK_PERIOD_IN_DAYS =>
      val r = LookbackPeriodInDays
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_TYPE =>
      val r = CurrentConfigurationVolumeType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BASELINE_IOPS =>
      val r = CurrentConfigurationVolumeBaselineIOPS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT =>
      val r = CurrentConfigurationVolumeBaselineThroughput
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BURST_IOPS =>
      val r = CurrentConfigurationVolumeBurstIOPS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BURST_THROUGHPUT =>
      val r = CurrentConfigurationVolumeBurstThroughput
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_SIZE =>
      val r = CurrentConfigurationVolumeSize
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_MONTHLY_PRICE =>
      val r = CurrentMonthlyPrice
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_TYPE =>
      val r = RecommendationOptionsConfigurationVolumeType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_IOPS =>
      val r = RecommendationOptionsConfigurationVolumeBaselineIOPS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT =>
      val r = RecommendationOptionsConfigurationVolumeBaselineThroughput
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_IOPS =>
      val r = RecommendationOptionsConfigurationVolumeBurstIOPS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_THROUGHPUT =>
      val r = RecommendationOptionsConfigurationVolumeBurstThroughput
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_SIZE =>
      val r = RecommendationOptionsConfigurationVolumeSize
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_MONTHLY_PRICE =>
      val r = RecommendationOptionsMonthlyPrice
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_PERFORMANCE_RISK =>
      val r = RecommendationOptionsPerformanceRisk
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.LAST_REFRESH_TIMESTAMP =>
      val r = LastRefreshTimestamp
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_PERFORMANCE_RISK =>
      val r = CurrentPerformanceRisk
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE =>
      val r = RecommendationOptionsSavingsOpportunityPercentage
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY =>
      val r = RecommendationOptionsEstimatedMonthlySavingsCurrency
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE =>
      val r = RecommendationOptionsEstimatedMonthlySavingsValue
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.ROOT_VOLUME =>
      val r = RootVolume
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.ACCOUNT_ID
  }
  case object VolumeArn
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.VOLUME_ARN
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.FINDING
  }
  case object UtilizationMetricsVolumeReadOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_READ_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsVolumeWriteOpsPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_WRITE_OPS_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsVolumeReadBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_READ_BYTES_PER_SECOND_MAXIMUM
  }
  case object UtilizationMetricsVolumeWriteBytesPerSecondMaximum
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.UTILIZATION_METRICS_VOLUME_WRITE_BYTES_PER_SECOND_MAXIMUM
  }
  case object LookbackPeriodInDays
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.LOOKBACK_PERIOD_IN_DAYS
  }
  case object CurrentConfigurationVolumeType
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_TYPE
  }
  case object CurrentConfigurationVolumeBaselineIOPS
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BASELINE_IOPS
  }
  case object CurrentConfigurationVolumeBaselineThroughput
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT
  }
  case object CurrentConfigurationVolumeBurstIOPS
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BURST_IOPS
  }
  case object CurrentConfigurationVolumeBurstThroughput
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_BURST_THROUGHPUT
  }
  case object CurrentConfigurationVolumeSize
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_CONFIGURATION_VOLUME_SIZE
  }
  case object CurrentMonthlyPrice
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_MONTHLY_PRICE
  }
  case object RecommendationOptionsConfigurationVolumeType
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_TYPE
  }
  case object RecommendationOptionsConfigurationVolumeBaselineIOPS
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_IOPS
  }
  case object RecommendationOptionsConfigurationVolumeBaselineThroughput
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT
  }
  case object RecommendationOptionsConfigurationVolumeBurstIOPS
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_IOPS
  }
  case object RecommendationOptionsConfigurationVolumeBurstThroughput
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_THROUGHPUT
  }
  case object RecommendationOptionsConfigurationVolumeSize
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_SIZE
  }
  case object RecommendationOptionsMonthlyPrice
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_MONTHLY_PRICE
  }
  case object RecommendationOptionsPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_PERFORMANCE_RISK
  }
  case object LastRefreshTimestamp
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.LAST_REFRESH_TIMESTAMP
  }
  case object CurrentPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.CURRENT_PERFORMANCE_RISK
  }
  case object RecommendationOptionsSavingsOpportunityPercentage
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE
  }
  case object RecommendationOptionsEstimatedMonthlySavingsCurrency
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY
  }
  case object RecommendationOptionsEstimatedMonthlySavingsValue
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE
  }
  case object RootVolume
      extends zio.aws.computeoptimizer.model.ExportableVolumeField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableVolumeField.ROOT_VOLUME
  }
}
