package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.Value
import scala.jdk.CollectionConverters._
final case class EstimatedMonthlySavings(
    currency: Optional[zio.aws.computeoptimizer.model.Currency] =
      Optional.Absent,
    value: Optional[Value] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings = {
    import EstimatedMonthlySavings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly =
    zio.aws.computeoptimizer.model.EstimatedMonthlySavings.wrap(buildAwsValue())
}
object EstimatedMonthlySavings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.EstimatedMonthlySavings =
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings(
        currency.map(value => value),
        value.map(value => value)
      )
    def currency: Optional[zio.aws.computeoptimizer.model.Currency]
    def value: Optional[Value]
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings
  ) extends zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly {
    override val currency: Optional[zio.aws.computeoptimizer.model.Currency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.computeoptimizer.model.Currency.wrap(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.computeoptimizer.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings
  ): zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly =
    new Wrapper(impl)
}
