package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GpuInfo(
    gpus: Optional[Iterable[zio.aws.computeoptimizer.model.Gpu]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GpuInfo = {
    import GpuInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GpuInfo
      .builder()
      .optionallyWith(
        gpus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gpus)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.GpuInfo.ReadOnly =
    zio.aws.computeoptimizer.model.GpuInfo.wrap(buildAwsValue())
}
object GpuInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GpuInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.GpuInfo =
      zio.aws.computeoptimizer.model.GpuInfo(
        gpus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gpus: Optional[List[zio.aws.computeoptimizer.model.Gpu.ReadOnly]]
    def getGpus: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Gpu.ReadOnly
    ]] = AwsError.unwrapOptionField("gpus", gpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GpuInfo
  ) extends zio.aws.computeoptimizer.model.GpuInfo.ReadOnly {
    override val gpus
        : Optional[List[zio.aws.computeoptimizer.model.Gpu.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gpus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.Gpu.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GpuInfo
  ): zio.aws.computeoptimizer.model.GpuInfo.ReadOnly = new Wrapper(impl)
}
