package zio.aws.computeoptimizer
import zio.aws.computeoptimizer.model.LambdaFunctionRecommendation.ReadOnly
import zio.aws.computeoptimizer.model.{
  GetEnrollmentStatusesForOrganizationRequest,
  UpdateEnrollmentStatusRequest,
  ExportLambdaFunctionRecommendationsRequest,
  DeleteRecommendationPreferencesRequest,
  GetEffectiveRecommendationPreferencesRequest,
  GetEnrollmentStatusRequest,
  GetRecommendationPreferencesRequest,
  GetAutoScalingGroupRecommendationsRequest,
  ExportEc2InstanceRecommendationsRequest,
  GetEc2RecommendationProjectedMetricsRequest,
  DescribeRecommendationExportJobsRequest,
  GetLambdaFunctionRecommendationsRequest,
  ExportEcsServiceRecommendationsRequest,
  GetEcsServiceRecommendationsRequest,
  ExportAutoScalingGroupRecommendationsRequest,
  PutRecommendationPreferencesRequest,
  GetRecommendationSummariesRequest,
  GetEcsServiceRecommendationProjectedMetricsRequest,
  GetEc2InstanceRecommendationsRequest,
  GetEbsVolumeRecommendationsRequest,
  ExportEbsVolumeRecommendationsRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient
import zio.stream.ZStream
object ComputeOptimizerMock extends Mock[ComputeOptimizer] {
  object GetEBSVolumeRecommendations
      extends Effect[
        GetEbsVolumeRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
      ]
  object GetECSServiceRecommendationProjectedMetrics
      extends Effect[
        GetEcsServiceRecommendationProjectedMetricsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly
      ]
  object GetEC2RecommendationProjectedMetrics
      extends Effect[
        GetEc2RecommendationProjectedMetricsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
      ]
  object ExportLambdaFunctionRecommendations
      extends Effect[
        ExportLambdaFunctionRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
      ]
  object DeleteRecommendationPreferences
      extends Effect[
        DeleteRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
      ]
  object ExportECSServiceRecommendations
      extends Effect[
        ExportEcsServiceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.ReadOnly
      ]
  object ExportEC2InstanceRecommendations
      extends Effect[
        ExportEc2InstanceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
      ]
  object GetEnrollmentStatusesForOrganization
      extends Stream[
        GetEnrollmentStatusesForOrganizationRequest,
        AwsError,
        zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
      ]
  object GetEnrollmentStatusesForOrganizationPaginated
      extends Effect[
        GetEnrollmentStatusesForOrganizationRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
      ]
  object PutRecommendationPreferences
      extends Effect[
        PutRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
      ]
  object GetECSServiceRecommendations
      extends Effect[
        GetEcsServiceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly
      ]
  object GetEffectiveRecommendationPreferences
      extends Effect[
        GetEffectiveRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
      ]
  object GetEnrollmentStatus
      extends Effect[
        GetEnrollmentStatusRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
      ]
  object GetEC2InstanceRecommendations
      extends Effect[
        GetEc2InstanceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
      ]
  object GetAutoScalingGroupRecommendations
      extends Effect[
        GetAutoScalingGroupRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
      ]
  object UpdateEnrollmentStatus
      extends Effect[
        UpdateEnrollmentStatusRequest,
        AwsError,
        zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
      ]
  object GetLambdaFunctionRecommendations
      extends Stream[
        GetLambdaFunctionRecommendationsRequest,
        AwsError,
        ReadOnly
      ]
  object GetLambdaFunctionRecommendationsPaginated
      extends Effect[
        GetLambdaFunctionRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
      ]
  object ExportEBSVolumeRecommendations
      extends Effect[
        ExportEbsVolumeRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
      ]
  object ExportAutoScalingGroupRecommendations
      extends Effect[
        ExportAutoScalingGroupRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
      ]
  object DescribeRecommendationExportJobs
      extends Stream[
        DescribeRecommendationExportJobsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
      ]
  object DescribeRecommendationExportJobsPaginated
      extends Effect[
        DescribeRecommendationExportJobsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
      ]
  object GetRecommendationPreferences
      extends Stream[
        GetRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
      ]
  object GetRecommendationPreferencesPaginated
      extends Effect[
        GetRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
      ]
  object GetRecommendationSummaries
      extends Stream[
        GetRecommendationSummariesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
      ]
  object GetRecommendationSummariesPaginated
      extends Effect[
        GetRecommendationSummariesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ComputeOptimizer] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ComputeOptimizer] { rts =>
        zio.ZIO.succeed {
          new ComputeOptimizer {
            val api: ComputeOptimizerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ComputeOptimizer = this
            def getEBSVolumeRecommendations(
                request: GetEbsVolumeRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
            ] = proxy(GetEBSVolumeRecommendations, request)
            def getECSServiceRecommendationProjectedMetrics(
                request: GetEcsServiceRecommendationProjectedMetricsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse.ReadOnly
            ] = proxy(GetECSServiceRecommendationProjectedMetrics, request)
            def getEC2RecommendationProjectedMetrics(
                request: GetEc2RecommendationProjectedMetricsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
            ] = proxy(GetEC2RecommendationProjectedMetrics, request)
            def exportLambdaFunctionRecommendations(
                request: ExportLambdaFunctionRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
            ] = proxy(ExportLambdaFunctionRecommendations, request)
            def deleteRecommendationPreferences(
                request: DeleteRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
            ] = proxy(DeleteRecommendationPreferences, request)
            def exportECSServiceRecommendations(
                request: ExportEcsServiceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportEcsServiceRecommendationsResponse.ReadOnly
            ] = proxy(ExportECSServiceRecommendations, request)
            def exportEC2InstanceRecommendations(
                request: ExportEc2InstanceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
            ] = proxy(ExportEC2InstanceRecommendations, request)
            def getEnrollmentStatusesForOrganization(
                request: GetEnrollmentStatusesForOrganizationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetEnrollmentStatusesForOrganization, request)
                }
                .getOrThrowFiberFailure()
            }
            def getEnrollmentStatusesForOrganizationPaginated(
                request: GetEnrollmentStatusesForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
            ] = proxy(GetEnrollmentStatusesForOrganizationPaginated, request)
            def putRecommendationPreferences(
                request: PutRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
            ] = proxy(PutRecommendationPreferences, request)
            def getECSServiceRecommendations(
                request: GetEcsServiceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEcsServiceRecommendationsResponse.ReadOnly
            ] = proxy(GetECSServiceRecommendations, request)
            def getEffectiveRecommendationPreferences(
                request: GetEffectiveRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
            ] = proxy(GetEffectiveRecommendationPreferences, request)
            def getEnrollmentStatus(request: GetEnrollmentStatusRequest): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
            ] = proxy(GetEnrollmentStatus, request)
            def getEC2InstanceRecommendations(
                request: GetEc2InstanceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
            ] = proxy(GetEC2InstanceRecommendations, request)
            def getAutoScalingGroupRecommendations(
                request: GetAutoScalingGroupRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
            ] = proxy(GetAutoScalingGroupRecommendations, request)
            def updateEnrollmentStatus(
                request: UpdateEnrollmentStatusRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
            ] = proxy(UpdateEnrollmentStatus, request)
            def getLambdaFunctionRecommendations(
                request: GetLambdaFunctionRecommendationsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetLambdaFunctionRecommendations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getLambdaFunctionRecommendationsPaginated(
                request: GetLambdaFunctionRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
            ] = proxy(GetLambdaFunctionRecommendationsPaginated, request)
            def exportEBSVolumeRecommendations(
                request: ExportEbsVolumeRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
            ] = proxy(ExportEBSVolumeRecommendations, request)
            def exportAutoScalingGroupRecommendations(
                request: ExportAutoScalingGroupRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
            ] = proxy(ExportAutoScalingGroupRecommendations, request)
            def describeRecommendationExportJobs(
                request: DescribeRecommendationExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.computeoptimizer.model.RecommendationExportJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRecommendationExportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRecommendationExportJobsPaginated(
                request: DescribeRecommendationExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
            ] = proxy(DescribeRecommendationExportJobsPaginated, request)
            def getRecommendationPreferences(
                request: GetRecommendationPreferencesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.computeoptimizer.model.RecommendationPreferencesDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetRecommendationPreferences, request)
                }
                .getOrThrowFiberFailure()
            }
            def getRecommendationPreferencesPaginated(
                request: GetRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
            ] = proxy(GetRecommendationPreferencesPaginated, request)
            def getRecommendationSummaries(
                request: GetRecommendationSummariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetRecommendationSummaries, request)
                }
                .getOrThrowFiberFailure()
            }
            def getRecommendationSummariesPaginated(
                request: GetRecommendationSummariesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
            ] = proxy(GetRecommendationSummariesPaginated, request)
          }
        }
      }
    }
  }
}
