package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  MaxResults,
  NextToken,
  VolumeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEbsVolumeRecommendationsRequest(
    volumeArns: Optional[Iterable[VolumeArn]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.computeoptimizer.model.EBSFilter]] =
      Optional.Absent,
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest = {
    import GetEbsVolumeRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
      .builder()
      .optionallyWith(
        volumeArns.map(value =>
          value.map { item =>
            VolumeArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetEbsVolumeRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest(
        volumeArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accountIds.map(value => value)
      )
    def volumeArns: Optional[List[VolumeArn]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filters
        : Optional[List[zio.aws.computeoptimizer.model.EBSFilter.ReadOnly]]
    def accountIds: Optional[List[AccountId]]
    def getVolumeArns: ZIO[Any, AwsError, List[VolumeArn]] =
      AwsError.unwrapOptionField("volumeArns", volumeArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.EBSFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest.ReadOnly {
    override val volumeArns: Optional[List[VolumeArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.VolumeArn(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
    override val filters
        : Optional[List[zio.aws.computeoptimizer.model.EBSFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.EBSFilter.wrap(item)
          }.toList
        )
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
