package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExternalMetricStatusCode {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode
}
object ExternalMetricStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode
  ): zio.aws.computeoptimizer.model.ExternalMetricStatusCode = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.NO_EXTERNAL_METRIC_SET =>
      val r = NO_EXTERNAL_METRIC_SET
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INTEGRATION_SUCCESS =>
      val r = INTEGRATION_SUCCESS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.DATADOG_INTEGRATION_ERROR =>
      val r = DATADOG_INTEGRATION_ERROR
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.DYNATRACE_INTEGRATION_ERROR =>
      val r = DYNATRACE_INTEGRATION_ERROR
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.NEWRELIC_INTEGRATION_ERROR =>
      val r = NEWRELIC_INTEGRATION_ERROR
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSTANA_INTEGRATION_ERROR =>
      val r = INSTANA_INTEGRATION_ERROR
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_DATADOG_METRICS =>
      val r = INSUFFICIENT_DATADOG_METRICS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_DYNATRACE_METRICS =>
      val r = INSUFFICIENT_DYNATRACE_METRICS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_NEWRELIC_METRICS =>
      val r = INSUFFICIENT_NEWRELIC_METRICS
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_INSTANA_METRICS =>
      val r = INSUFFICIENT_INSTANA_METRICS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_EXTERNAL_METRIC_SET
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.NO_EXTERNAL_METRIC_SET
  }
  case object INTEGRATION_SUCCESS
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INTEGRATION_SUCCESS
  }
  case object DATADOG_INTEGRATION_ERROR
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.DATADOG_INTEGRATION_ERROR
  }
  case object DYNATRACE_INTEGRATION_ERROR
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.DYNATRACE_INTEGRATION_ERROR
  }
  case object NEWRELIC_INTEGRATION_ERROR
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.NEWRELIC_INTEGRATION_ERROR
  }
  case object INSTANA_INTEGRATION_ERROR
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSTANA_INTEGRATION_ERROR
  }
  case object INSUFFICIENT_DATADOG_METRICS
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_DATADOG_METRICS
  }
  case object INSUFFICIENT_DYNATRACE_METRICS
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_DYNATRACE_METRICS
  }
  case object INSUFFICIENT_NEWRELIC_METRICS
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_NEWRELIC_METRICS
  }
  case object INSUFFICIENT_INSTANA_METRICS
      extends zio.aws.computeoptimizer.model.ExternalMetricStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode =
      software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatusCode.INSUFFICIENT_INSTANA_METRICS
  }
}
