package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ExportableECSServiceField {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField
}
object ExportableECSServiceField {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField
  ): zio.aws.computeoptimizer.model.ExportableECSServiceField = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.ACCOUNT_ID =>
      val r = AccountId
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.SERVICE_ARN =>
      val r = ServiceArn
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LOOKBACK_PERIOD_IN_DAYS =>
      val r = LookbackPeriodInDays
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LAST_REFRESH_TIMESTAMP =>
      val r = LastRefreshTimestamp
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LAUNCH_TYPE =>
      val r = LaunchType
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_PERFORMANCE_RISK =>
      val r = CurrentPerformanceRisk
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_MEMORY =>
      val r = CurrentServiceConfigurationMemory
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_CPU =>
      val r = CurrentServiceConfigurationCpu
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_TASK_DEFINITION_ARN =>
      val r = CurrentServiceConfigurationTaskDefinitionArn
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_AUTO_SCALING_CONFIGURATION =>
      val r = CurrentServiceConfigurationAutoScalingConfiguration
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONTAINER_CONFIGURATIONS =>
      val r = CurrentServiceContainerConfigurations
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UTILIZATION_METRICS_CPU_MAXIMUM =>
      val r = UtilizationMetricsCpuMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UTILIZATION_METRICS_MEMORY_MAXIMUM =>
      val r = UtilizationMetricsMemoryMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.FINDING =>
      val r = Finding
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.FINDING_REASON_CODES =>
      val r = FindingReasonCodes
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_MEMORY =>
      val r = RecommendationOptionsMemory
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_CPU =>
      val r = RecommendationOptionsCpu
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE =>
      val r = RecommendationOptionsSavingsOpportunityPercentage
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY =>
      val r = RecommendationOptionsEstimatedMonthlySavingsCurrency
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE =>
      val r = RecommendationOptionsEstimatedMonthlySavingsValue
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_CONTAINER_RECOMMENDATIONS =>
      val r = RecommendationOptionsContainerRecommendations
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM =>
      val r = RecommendationOptionsProjectedUtilizationMetricsCpuMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM =>
      val r = RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum
      r
    case software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.TAGS =>
      val r = Tags
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UNKNOWN_TO_SDK_VERSION
  }
  case object AccountId
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.ACCOUNT_ID
  }
  case object ServiceArn
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.SERVICE_ARN
  }
  case object LookbackPeriodInDays
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LOOKBACK_PERIOD_IN_DAYS
  }
  case object LastRefreshTimestamp
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LAST_REFRESH_TIMESTAMP
  }
  case object LaunchType
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.LAUNCH_TYPE
  }
  case object CurrentPerformanceRisk
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_PERFORMANCE_RISK
  }
  case object CurrentServiceConfigurationMemory
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_MEMORY
  }
  case object CurrentServiceConfigurationCpu
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_CPU
  }
  case object CurrentServiceConfigurationTaskDefinitionArn
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_TASK_DEFINITION_ARN
  }
  case object CurrentServiceConfigurationAutoScalingConfiguration
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONFIGURATION_AUTO_SCALING_CONFIGURATION
  }
  case object CurrentServiceContainerConfigurations
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.CURRENT_SERVICE_CONTAINER_CONFIGURATIONS
  }
  case object UtilizationMetricsCpuMaximum
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UTILIZATION_METRICS_CPU_MAXIMUM
  }
  case object UtilizationMetricsMemoryMaximum
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.UTILIZATION_METRICS_MEMORY_MAXIMUM
  }
  case object Finding
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.FINDING
  }
  case object FindingReasonCodes
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.FINDING_REASON_CODES
  }
  case object RecommendationOptionsMemory
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_MEMORY
  }
  case object RecommendationOptionsCpu
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_CPU
  }
  case object RecommendationOptionsSavingsOpportunityPercentage
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE
  }
  case object RecommendationOptionsEstimatedMonthlySavingsCurrency
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY
  }
  case object RecommendationOptionsEstimatedMonthlySavingsValue
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE
  }
  case object RecommendationOptionsContainerRecommendations
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_CONTAINER_RECOMMENDATIONS
  }
  case object RecommendationOptionsProjectedUtilizationMetricsCpuMaximum
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM
  }
  case object RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM
  }
  case object Tags
      extends zio.aws.computeoptimizer.model.ExportableECSServiceField {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField =
      software.amazon.awssdk.services.computeoptimizer.model.ExportableECSServiceField.TAGS
  }
}
