package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.ExternalMetricStatusReason
import scala.jdk.CollectionConverters._
final case class ExternalMetricStatus(
    statusCode: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricStatusCode
    ] = Optional.Absent,
    statusReason: Optional[ExternalMetricStatusReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus = {
    import ExternalMetricStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        statusReason.map(value =>
          ExternalMetricStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly =
    zio.aws.computeoptimizer.model.ExternalMetricStatus.wrap(buildAwsValue())
}
object ExternalMetricStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.ExternalMetricStatus =
      zio.aws.computeoptimizer.model.ExternalMetricStatus(
        statusCode.map(value => value),
        statusReason.map(value => value)
      )
    def statusCode
        : Optional[zio.aws.computeoptimizer.model.ExternalMetricStatusCode]
    def statusReason: Optional[ExternalMetricStatusReason]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusReason: ZIO[Any, AwsError, ExternalMetricStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus
  ) extends zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly {
    override val statusCode
        : Optional[zio.aws.computeoptimizer.model.ExternalMetricStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.computeoptimizer.model.ExternalMetricStatusCode.wrap(value)
        )
    override val statusReason: Optional[ExternalMetricStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .ExternalMetricStatusReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus
  ): zio.aws.computeoptimizer.model.ExternalMetricStatus.ReadOnly = new Wrapper(
    impl
  )
}
