package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{Rank, PerformanceRisk}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutoScalingGroupRecommendationOption(
    configuration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration
    ] = Optional.Absent,
    projectedUtilizationMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.UtilizationMetric]
    ] = Optional.Absent,
    performanceRisk: Optional[PerformanceRisk] = Optional.Absent,
    rank: Optional[Rank] = Optional.Absent,
    savingsOpportunity: Optional[
      zio.aws.computeoptimizer.model.SavingsOpportunity
    ] = Optional.Absent,
    migrationEffort: Optional[zio.aws.computeoptimizer.model.MigrationEffort] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption = {
    import AutoScalingGroupRecommendationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedUtilizationMetrics)
      .optionallyWith(
        performanceRisk.map(value =>
          PerformanceRisk.unwrap(value): java.lang.Double
        )
      )(_.performanceRisk)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(savingsOpportunity.map(value => value.buildAwsValue()))(
        _.savingsOpportunity
      )
      .optionallyWith(migrationEffort.map(value => value.unwrap))(
        _.migrationEffort
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly =
    zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption
      .wrap(buildAwsValue())
}
object AutoScalingGroupRecommendationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption =
      zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption(
        configuration.map(value => value.asEditable),
        projectedUtilizationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        performanceRisk.map(value => value),
        rank.map(value => value),
        savingsOpportunity.map(value => value.asEditable),
        migrationEffort.map(value => value)
      )
    def configuration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ]
    def projectedUtilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ]
    def performanceRisk: Optional[PerformanceRisk]
    def rank: Optional[Rank]
    def savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly]
    def migrationEffort
        : Optional[zio.aws.computeoptimizer.model.MigrationEffort]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getProjectedUtilizationMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "projectedUtilizationMetrics",
      projectedUtilizationMetrics
    )
    def getPerformanceRisk: ZIO[Any, AwsError, PerformanceRisk] =
      AwsError.unwrapOptionField("performanceRisk", performanceRisk)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getSavingsOpportunity: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly
    ] = AwsError.unwrapOptionField("savingsOpportunity", savingsOpportunity)
    def getMigrationEffort
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MigrationEffort] =
      AwsError.unwrapOptionField("migrationEffort", migrationEffort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ) extends zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly {
    override val configuration: Optional[
      zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.computeoptimizer.model.AutoScalingGroupConfiguration.wrap(value)
      )
    override val projectedUtilizationMetrics: Optional[
      List[zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedUtilizationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.UtilizationMetric.wrap(item)
        }.toList
      )
    override val performanceRisk: Optional[PerformanceRisk] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceRisk())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.PerformanceRisk(value)
        )
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val savingsOpportunity
        : Optional[zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.savingsOpportunity())
        .map(value =>
          zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(value)
        )
    override val migrationEffort
        : Optional[zio.aws.computeoptimizer.model.MigrationEffort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationEffort())
        .map(value =>
          zio.aws.computeoptimizer.model.MigrationEffort.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption
  ): zio.aws.computeoptimizer.model.AutoScalingGroupRecommendationOption.ReadOnly =
    new Wrapper(impl)
}
