package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutRecommendationPreferencesRequest(
    resourceType: zio.aws.computeoptimizer.model.ResourceType,
    scope: Optional[zio.aws.computeoptimizer.model.Scope] = Optional.Absent,
    enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = Optional.Absent,
    inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = Optional.Absent,
    externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest = {
    import PutRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(inferredWorkloadTypes.map(value => value.unwrap))(
        _.inferredWorkloadTypes
      )
      .optionallyWith(
        externalMetricsPreference.map(value => value.buildAwsValue())
      )(_.externalMetricsPreference)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object PutRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest(
        resourceType,
        scope.map(value => value.asEditable),
        enhancedInfrastructureMetrics.map(value => value),
        inferredWorkloadTypes.map(value => value),
        externalMetricsPreference.map(value => value.asEditable)
      )
    def resourceType: zio.aws.computeoptimizer.model.ResourceType
    def scope: Optional[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def enhancedInfrastructureMetrics
        : Optional[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ]
    def externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getInferredWorkloadTypes: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
    def getExternalMetricsPreference: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalMetricsPreference",
      externalMetricsPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly {
    override val resourceType: zio.aws.computeoptimizer.model.ResourceType =
      zio.aws.computeoptimizer.model.ResourceType.wrap(impl.resourceType())
    override val scope
        : Optional[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedInfrastructureMetrics())
      .map(value =>
        zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics.wrap(value)
      )
    override val inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferredWorkloadTypes())
      .map(value =>
        zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
          .wrap(value)
      )
    override val externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.externalMetricsPreference())
      .map(value =>
        zio.aws.computeoptimizer.model.ExternalMetricsPreference.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.PutRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
