package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait ECSServiceRecommendationFinding {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding
}
object ECSServiceRecommendationFinding {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding
  ): zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.OPTIMIZED =>
        val r = Optimized
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.UNDERPROVISIONED =>
        val r = Underprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.OVERPROVISIONED =>
        val r = Overprovisioned
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.UNKNOWN_TO_SDK_VERSION
  }
  case object Optimized
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.OPTIMIZED
  }
  case object Underprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.UNDERPROVISIONED
  }
  case object Overprovisioned
      extends zio.aws.computeoptimizer.model.ECSServiceRecommendationFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding =
      software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding.OVERPROVISIONED
  }
}
