package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.MetricValue
import scala.jdk.CollectionConverters._
final case class UtilizationMetric(
    name: Optional[zio.aws.computeoptimizer.model.MetricName] = Optional.Absent,
    statistic: Optional[zio.aws.computeoptimizer.model.MetricStatistic] =
      Optional.Absent,
    value: Optional[MetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric = {
    import UtilizationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        value.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly =
    zio.aws.computeoptimizer.model.UtilizationMetric.wrap(buildAwsValue())
}
object UtilizationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.UtilizationMetric =
      zio.aws.computeoptimizer.model.UtilizationMetric(
        name.map(value => value),
        statistic.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.computeoptimizer.model.MetricName]
    def statistic: Optional[zio.aws.computeoptimizer.model.MetricStatistic]
    def value: Optional[MetricValue]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricName] =
      AwsError.unwrapOptionField("name", name)
    def getStatistic
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.MetricStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ) extends zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly {
    override val name: Optional[zio.aws.computeoptimizer.model.MetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.computeoptimizer.model.MetricName.wrap(value))
    override val statistic
        : Optional[zio.aws.computeoptimizer.model.MetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.computeoptimizer.model.MetricStatistic.wrap(value)
        )
    override val value: Optional[MetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.MetricValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric
  ): zio.aws.computeoptimizer.model.UtilizationMetric.ReadOnly = new Wrapper(
    impl
  )
}
