package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EffectiveRecommendationPreferences(
    cpuVendorArchitectures: Optional[
      Iterable[zio.aws.computeoptimizer.model.CpuVendorArchitecture]
    ] = Optional.Absent,
    enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = Optional.Absent,
    inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = Optional.Absent,
    externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences = {
    import EffectiveRecommendationPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
      .builder()
      .optionallyWith(
        cpuVendorArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuVendorArchitecturesWithStrings)
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .optionallyWith(inferredWorkloadTypes.map(value => value.unwrap))(
        _.inferredWorkloadTypes
      )
      .optionallyWith(
        externalMetricsPreference.map(value => value.buildAwsValue())
      )(_.externalMetricsPreference)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly =
    zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences
      .wrap(buildAwsValue())
}
object EffectiveRecommendationPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences =
      zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences(
        cpuVendorArchitectures.map(value => value),
        enhancedInfrastructureMetrics.map(value => value),
        inferredWorkloadTypes.map(value => value),
        externalMetricsPreference.map(value => value.asEditable)
      )
    def cpuVendorArchitectures
        : Optional[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]]
    def enhancedInfrastructureMetrics
        : Optional[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ]
    def externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ]
    def getCpuVendorArchitectures: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.CpuVendorArchitecture
    ]] = AwsError.unwrapOptionField(
      "cpuVendorArchitectures",
      cpuVendorArchitectures
    )
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
    def getInferredWorkloadTypes: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] =
      AwsError.unwrapOptionField("inferredWorkloadTypes", inferredWorkloadTypes)
    def getExternalMetricsPreference: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "externalMetricsPreference",
      externalMetricsPreference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ) extends zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly {
    override val cpuVendorArchitectures
        : Optional[List[zio.aws.computeoptimizer.model.CpuVendorArchitecture]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuVendorArchitectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.computeoptimizer.model.CpuVendorArchitecture.wrap(item)
          }.toList
        )
    override val enhancedInfrastructureMetrics: Optional[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedInfrastructureMetrics())
      .map(value =>
        zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics.wrap(value)
      )
    override val inferredWorkloadTypes: Optional[
      zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferredWorkloadTypes())
      .map(value =>
        zio.aws.computeoptimizer.model.InferredWorkloadTypesPreference
          .wrap(value)
      )
    override val externalMetricsPreference: Optional[
      zio.aws.computeoptimizer.model.ExternalMetricsPreference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.externalMetricsPreference())
      .map(value =>
        zio.aws.computeoptimizer.model.ExternalMetricsPreference.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences
  ): zio.aws.computeoptimizer.model.EffectiveRecommendationPreferences.ReadOnly =
    new Wrapper(impl)
}
