package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait Finding {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.Finding
}
object Finding {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.Finding
  ): zio.aws.computeoptimizer.model.Finding = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.Finding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Finding.UNDERPROVISIONED =>
      val r = Underprovisioned
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Finding.OVERPROVISIONED =>
      val r = Overprovisioned
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Finding.OPTIMIZED =>
      val r = Optimized
      r
    case software.amazon.awssdk.services.computeoptimizer.model.Finding.NOT_OPTIMIZED =>
      val r = NotOptimized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.Finding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Finding =
      software.amazon.awssdk.services.computeoptimizer.model.Finding.UNKNOWN_TO_SDK_VERSION
  }
  case object Underprovisioned extends zio.aws.computeoptimizer.model.Finding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Finding =
      software.amazon.awssdk.services.computeoptimizer.model.Finding.UNDERPROVISIONED
  }
  case object Overprovisioned extends zio.aws.computeoptimizer.model.Finding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Finding =
      software.amazon.awssdk.services.computeoptimizer.model.Finding.OVERPROVISIONED
  }
  case object Optimized extends zio.aws.computeoptimizer.model.Finding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Finding =
      software.amazon.awssdk.services.computeoptimizer.model.Finding.OPTIMIZED
  }
  case object NotOptimized extends zio.aws.computeoptimizer.model.Finding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.Finding =
      software.amazon.awssdk.services.computeoptimizer.model.Finding.NOT_OPTIMIZED
  }
}
