package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait MigrationEffort {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort
}
object MigrationEffort {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort
  ): zio.aws.computeoptimizer.model.MigrationEffort = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.VERY_LOW =>
      val r = VeryLow
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.LOW =>
      val r = Low
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.MEDIUM =>
      val r = Medium
      r
    case software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.HIGH =>
      val r = High
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.MigrationEffort {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort =
      software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.UNKNOWN_TO_SDK_VERSION
  }
  case object VeryLow extends zio.aws.computeoptimizer.model.MigrationEffort {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort =
      software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.VERY_LOW
  }
  case object Low extends zio.aws.computeoptimizer.model.MigrationEffort {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort =
      software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.LOW
  }
  case object Medium extends zio.aws.computeoptimizer.model.MigrationEffort {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort =
      software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.MEDIUM
  }
  case object High extends zio.aws.computeoptimizer.model.MigrationEffort {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort =
      software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort.HIGH
  }
}
