package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.SummaryValue
import scala.jdk.CollectionConverters._
final case class Summary(
    name: Optional[zio.aws.computeoptimizer.model.Finding] = Optional.Absent,
    value: Optional[SummaryValue] = Optional.Absent,
    reasonCodeSummaries: Optional[
      Iterable[zio.aws.computeoptimizer.model.ReasonCodeSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.Summary = {
    import Summary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.Summary
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => SummaryValue.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(
        reasonCodeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reasonCodeSummaries)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.Summary.ReadOnly =
    zio.aws.computeoptimizer.model.Summary.wrap(buildAwsValue())
}
object Summary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.Summary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.Summary =
      zio.aws.computeoptimizer.model.Summary(
        name.map(value => value),
        value.map(value => value),
        reasonCodeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[zio.aws.computeoptimizer.model.Finding]
    def value: Optional[SummaryValue]
    def reasonCodeSummaries: Optional[
      List[zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Finding] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, SummaryValue] =
      AwsError.unwrapOptionField("value", value)
    def getReasonCodeSummaries: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reasonCodeSummaries", reasonCodeSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Summary
  ) extends zio.aws.computeoptimizer.model.Summary.ReadOnly {
    override val name: Optional[zio.aws.computeoptimizer.model.Finding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.computeoptimizer.model.Finding.wrap(value))
    override val value: Optional[SummaryValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.SummaryValue(value)
      )
    override val reasonCodeSummaries: Optional[
      List[zio.aws.computeoptimizer.model.ReasonCodeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCodeSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ReasonCodeSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.Summary
  ): zio.aws.computeoptimizer.model.Summary.ReadOnly = new Wrapper(impl)
}
