package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetRecommendationSummariesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    recommendationSummaries: Optional[
      Iterable[zio.aws.computeoptimizer.model.RecommendationSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse = {
    import GetRecommendationSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        recommendationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse
      .wrap(buildAwsValue())
}
object GetRecommendationSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse =
      zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse(
        nextToken.map(value => value),
        recommendationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def recommendationSummaries: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecommendationSummaries: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recommendationSummaries",
      recommendationSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse
  ) extends zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val recommendationSummaries: Optional[
      List[zio.aws.computeoptimizer.model.RecommendationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.RecommendationSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse
  ): zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
