package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetEbsVolumeRecommendationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    volumeRecommendations: Optional[
      Iterable[zio.aws.computeoptimizer.model.VolumeRecommendation]
    ] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.computeoptimizer.model.GetRecommendationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse = {
    import GetEbsVolumeRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        volumeRecommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeRecommendations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetEbsVolumeRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse =
      zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse(
        nextToken.map(value => value),
        volumeRecommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def volumeRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly]
    ]
    def errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVolumeRecommendations: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("volumeRecommendations", volumeRecommendations)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
  ) extends zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val volumeRecommendations: Optional[
      List[zio.aws.computeoptimizer.model.VolumeRecommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.VolumeRecommendation.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.computeoptimizer.model.GetRecommendationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.GetRecommendationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse
  ): zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
