package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetEnrollmentStatusesForOrganizationResponse(
    accountEnrollmentStatuses: Optional[
      Iterable[zio.aws.computeoptimizer.model.AccountEnrollmentStatus]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse = {
    import GetEnrollmentStatusesForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
      .builder()
      .optionallyWith(
        accountEnrollmentStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountEnrollmentStatuses)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
      .wrap(buildAwsValue())
}
object GetEnrollmentStatusesForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse =
      zio.aws.computeoptimizer.model
        .GetEnrollmentStatusesForOrganizationResponse(
          accountEnrollmentStatuses.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def accountEnrollmentStatuses: Optional[
      List[zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getAccountEnrollmentStatuses: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountEnrollmentStatuses",
      accountEnrollmentStatuses
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
  ) extends zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly {
    override val accountEnrollmentStatuses: Optional[
      List[zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountEnrollmentStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.AccountEnrollmentStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse
  ): zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
