package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait EBSFinding {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.EBSFinding
}
object EBSFinding {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.EBSFinding
  ): zio.aws.computeoptimizer.model.EBSFinding = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.OPTIMIZED =>
      val r = Optimized
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.NOT_OPTIMIZED =>
      val r = NotOptimized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.EBSFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSFinding =
      software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.UNKNOWN_TO_SDK_VERSION
  }
  case object Optimized extends zio.aws.computeoptimizer.model.EBSFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSFinding =
      software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.OPTIMIZED
  }
  case object NotOptimized extends zio.aws.computeoptimizer.model.EBSFinding {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSFinding =
      software.amazon.awssdk.services.computeoptimizer.model.EBSFinding.NOT_OPTIMIZED
  }
}
