package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait FilterName {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.FilterName
}
object FilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.FilterName
  ): zio.aws.computeoptimizer.model.FilterName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.FilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FilterName.FINDING =>
      val r = Finding
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FilterName.FINDING_REASON_CODES =>
      val r = FindingReasonCodes
      r
    case software.amazon.awssdk.services.computeoptimizer.model.FilterName.RECOMMENDATION_SOURCE_TYPE =>
      val r = RecommendationSourceType
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.FilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FilterName =
      software.amazon.awssdk.services.computeoptimizer.model.FilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object Finding extends zio.aws.computeoptimizer.model.FilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FilterName =
      software.amazon.awssdk.services.computeoptimizer.model.FilterName.FINDING
  }
  case object FindingReasonCodes
      extends zio.aws.computeoptimizer.model.FilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FilterName =
      software.amazon.awssdk.services.computeoptimizer.model.FilterName.FINDING_REASON_CODES
  }
  case object RecommendationSourceType
      extends zio.aws.computeoptimizer.model.FilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.FilterName =
      software.amazon.awssdk.services.computeoptimizer.model.FilterName.RECOMMENDATION_SOURCE_TYPE
  }
}
