package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{MaxResults, NextToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRecommendationPreferencesRequest(
    resourceType: zio.aws.computeoptimizer.model.ResourceType,
    scope: Optional[zio.aws.computeoptimizer.model.Scope] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest = {
    import GetRecommendationPreferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest
      .wrap(buildAwsValue())
}
object GetRecommendationPreferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest =
      zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest(
        resourceType,
        scope.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceType: zio.aws.computeoptimizer.model.ResourceType
    def scope: Optional[zio.aws.computeoptimizer.model.Scope.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.computeoptimizer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getScope
        : ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ) extends zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly {
    override val resourceType: zio.aws.computeoptimizer.model.ResourceType =
      zio.aws.computeoptimizer.model.ResourceType.wrap(impl.resourceType())
    override val scope
        : Optional[zio.aws.computeoptimizer.model.Scope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.computeoptimizer.model.Scope.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest
  ): zio.aws.computeoptimizer.model.GetRecommendationPreferencesRequest.ReadOnly =
    new Wrapper(impl)
}
