package zio.aws.computeoptimizer
import zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly
import zio.aws.computeoptimizer.model.{
  GetEnrollmentStatusesForOrganizationRequest,
  UpdateEnrollmentStatusRequest,
  ExportLambdaFunctionRecommendationsRequest,
  DeleteRecommendationPreferencesRequest,
  GetEffectiveRecommendationPreferencesRequest,
  GetEnrollmentStatusRequest,
  GetRecommendationPreferencesRequest,
  GetAutoScalingGroupRecommendationsRequest,
  ExportEc2InstanceRecommendationsRequest,
  GetEc2RecommendationProjectedMetricsRequest,
  DescribeRecommendationExportJobsRequest,
  GetLambdaFunctionRecommendationsRequest,
  ExportAutoScalingGroupRecommendationsRequest,
  PutRecommendationPreferencesRequest,
  GetRecommendationSummariesRequest,
  GetEc2InstanceRecommendationsRequest,
  GetEbsVolumeRecommendationsRequest,
  ExportEbsVolumeRecommendationsRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient
object ComputeOptimizerMock extends Mock[ComputeOptimizer] {
  object GetEBSVolumeRecommendations
      extends Effect[
        GetEbsVolumeRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
      ]
  object GetEC2RecommendationProjectedMetrics
      extends Effect[
        GetEc2RecommendationProjectedMetricsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
      ]
  object ExportLambdaFunctionRecommendations
      extends Effect[
        ExportLambdaFunctionRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
      ]
  object DeleteRecommendationPreferences
      extends Effect[
        DeleteRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
      ]
  object ExportEC2InstanceRecommendations
      extends Effect[
        ExportEc2InstanceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
      ]
  object GetEnrollmentStatusesForOrganization
      extends Effect[
        GetEnrollmentStatusesForOrganizationRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
      ]
  object PutRecommendationPreferences
      extends Effect[
        PutRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
      ]
  object GetEffectiveRecommendationPreferences
      extends Effect[
        GetEffectiveRecommendationPreferencesRequest,
        AwsError,
        ReadOnly
      ]
  object GetEnrollmentStatus
      extends Effect[
        GetEnrollmentStatusRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
      ]
  object GetEC2InstanceRecommendations
      extends Effect[
        GetEc2InstanceRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
      ]
  object GetAutoScalingGroupRecommendations
      extends Effect[
        GetAutoScalingGroupRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
      ]
  object UpdateEnrollmentStatus
      extends Effect[
        UpdateEnrollmentStatusRequest,
        AwsError,
        zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
      ]
  object GetLambdaFunctionRecommendations
      extends Effect[
        GetLambdaFunctionRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
      ]
  object ExportEBSVolumeRecommendations
      extends Effect[
        ExportEbsVolumeRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
      ]
  object ExportAutoScalingGroupRecommendations
      extends Effect[
        ExportAutoScalingGroupRecommendationsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
      ]
  object DescribeRecommendationExportJobs
      extends Effect[
        DescribeRecommendationExportJobsRequest,
        AwsError,
        zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
      ]
  object GetRecommendationPreferences
      extends Effect[
        GetRecommendationPreferencesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
      ]
  object GetRecommendationSummaries
      extends Effect[
        GetRecommendationSummariesRequest,
        AwsError,
        zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ComputeOptimizer] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ComputeOptimizer] { rts =>
        zio.ZIO.succeed {
          new ComputeOptimizer {
            val api: ComputeOptimizerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ComputeOptimizer = this
            def getEBSVolumeRecommendations(
                request: GetEbsVolumeRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEbsVolumeRecommendationsResponse.ReadOnly
            ] = proxy(GetEBSVolumeRecommendations, request)
            def getEC2RecommendationProjectedMetrics(
                request: GetEc2RecommendationProjectedMetricsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse.ReadOnly
            ] = proxy(GetEC2RecommendationProjectedMetrics, request)
            def exportLambdaFunctionRecommendations(
                request: ExportLambdaFunctionRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse.ReadOnly
            ] = proxy(ExportLambdaFunctionRecommendations, request)
            def deleteRecommendationPreferences(
                request: DeleteRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.DeleteRecommendationPreferencesResponse.ReadOnly
            ] = proxy(DeleteRecommendationPreferences, request)
            def exportEC2InstanceRecommendations(
                request: ExportEc2InstanceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse.ReadOnly
            ] = proxy(ExportEC2InstanceRecommendations, request)
            def getEnrollmentStatusesForOrganization(
                request: GetEnrollmentStatusesForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse.ReadOnly
            ] = proxy(GetEnrollmentStatusesForOrganization, request)
            def putRecommendationPreferences(
                request: PutRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.PutRecommendationPreferencesResponse.ReadOnly
            ] = proxy(PutRecommendationPreferences, request)
            def getEffectiveRecommendationPreferences(
                request: GetEffectiveRecommendationPreferencesRequest
            ): IO[AwsError, ReadOnly] =
              proxy(GetEffectiveRecommendationPreferences, request)
            def getEnrollmentStatus(request: GetEnrollmentStatusRequest): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEnrollmentStatusResponse.ReadOnly
            ] = proxy(GetEnrollmentStatus, request)
            def getEC2InstanceRecommendations(
                request: GetEc2InstanceRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsResponse.ReadOnly
            ] = proxy(GetEC2InstanceRecommendations, request)
            def getAutoScalingGroupRecommendations(
                request: GetAutoScalingGroupRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse.ReadOnly
            ] = proxy(GetAutoScalingGroupRecommendations, request)
            def updateEnrollmentStatus(
                request: UpdateEnrollmentStatusRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.UpdateEnrollmentStatusResponse.ReadOnly
            ] = proxy(UpdateEnrollmentStatus, request)
            def getLambdaFunctionRecommendations(
                request: GetLambdaFunctionRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse.ReadOnly
            ] = proxy(GetLambdaFunctionRecommendations, request)
            def exportEBSVolumeRecommendations(
                request: ExportEbsVolumeRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse.ReadOnly
            ] = proxy(ExportEBSVolumeRecommendations, request)
            def exportAutoScalingGroupRecommendations(
                request: ExportAutoScalingGroupRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse.ReadOnly
            ] = proxy(ExportAutoScalingGroupRecommendations, request)
            def describeRecommendationExportJobs(
                request: DescribeRecommendationExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.DescribeRecommendationExportJobsResponse.ReadOnly
            ] = proxy(DescribeRecommendationExportJobs, request)
            def getRecommendationPreferences(
                request: GetRecommendationPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetRecommendationPreferencesResponse.ReadOnly
            ] = proxy(GetRecommendationPreferences, request)
            def getRecommendationSummaries(
                request: GetRecommendationSummariesRequest
            ): IO[
              AwsError,
              zio.aws.computeoptimizer.model.GetRecommendationSummariesResponse.ReadOnly
            ] = proxy(GetRecommendationSummaries, request)
          }
        }
      }
    }
  }
}
