package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{Rank, RecommendedInstanceType}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RecommendedOptionProjectedMetric(
    recommendedInstanceType: Optional[RecommendedInstanceType] =
      Optional.Absent,
    rank: Optional[Rank] = Optional.Absent,
    projectedMetrics: Optional[
      Iterable[zio.aws.computeoptimizer.model.ProjectedMetric]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric = {
    import RecommendedOptionProjectedMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
      .builder()
      .optionallyWith(
        recommendedInstanceType.map(value =>
          RecommendedInstanceType.unwrap(value): java.lang.String
        )
      )(_.recommendedInstanceType)
      .optionallyWith(rank.map(value => Rank.unwrap(value): Integer))(_.rank)
      .optionallyWith(
        projectedMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectedMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly =
    zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric
      .wrap(buildAwsValue())
}
object RecommendedOptionProjectedMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric =
      zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric(
        recommendedInstanceType.map(value => value),
        rank.map(value => value),
        projectedMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def recommendedInstanceType: Optional[RecommendedInstanceType]
    def rank: Optional[Rank]
    def projectedMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly]
    ]
    def getRecommendedInstanceType
        : ZIO[Any, AwsError, RecommendedInstanceType] = AwsError
      .unwrapOptionField("recommendedInstanceType", recommendedInstanceType)
    def getRank: ZIO[Any, AwsError, Rank] =
      AwsError.unwrapOptionField("rank", rank)
    def getProjectedMetrics: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("projectedMetrics", projectedMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ) extends zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly {
    override val recommendedInstanceType: Optional[RecommendedInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendedInstanceType())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives
            .RecommendedInstanceType(value)
        )
    override val rank: Optional[Rank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.computeoptimizer.model.primitives.Rank(value))
    override val projectedMetrics: Optional[
      List[zio.aws.computeoptimizer.model.ProjectedMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.ProjectedMetric.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.RecommendedOptionProjectedMetric
  ): zio.aws.computeoptimizer.model.RecommendedOptionProjectedMetric.ReadOnly =
    new Wrapper(impl)
}
