package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait InstanceRecommendationFindingReasonCode {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode
}
object InstanceRecommendationFindingReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode
  ): zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
    value match {
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.CPU_OVERPROVISIONED =>
        val r = CPUOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.CPU_UNDERPROVISIONED =>
        val r = CPUUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.MEMORY_OVERPROVISIONED =>
        val r = MemoryOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.MEMORY_UNDERPROVISIONED =>
        val r = MemoryUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBS_THROUGHPUT_OVERPROVISIONED =>
        val r = EBSThroughputOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBS_THROUGHPUT_UNDERPROVISIONED =>
        val r = EBSThroughputUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBSIOPS_OVERPROVISIONED =>
        val r = EBSIOPSOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBSIOPS_UNDERPROVISIONED =>
        val r = EBSIOPSUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_BANDWIDTH_OVERPROVISIONED =>
        val r = NetworkBandwidthOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_BANDWIDTH_UNDERPROVISIONED =>
        val r = NetworkBandwidthUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_PPS_OVERPROVISIONED =>
        val r = NetworkPPSOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_PPS_UNDERPROVISIONED =>
        val r = NetworkPPSUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_IOPS_OVERPROVISIONED =>
        val r = DiskIOPSOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_IOPS_UNDERPROVISIONED =>
        val r = DiskIOPSUnderprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_THROUGHPUT_OVERPROVISIONED =>
        val r = DiskThroughputOverprovisioned
        r
      case software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_THROUGHPUT_UNDERPROVISIONED =>
        val r = DiskThroughputUnderprovisioned
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object CPUOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.CPU_OVERPROVISIONED
  }
  case object CPUUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.CPU_UNDERPROVISIONED
  }
  case object MemoryOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.MEMORY_OVERPROVISIONED
  }
  case object MemoryUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.MEMORY_UNDERPROVISIONED
  }
  case object EBSThroughputOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBS_THROUGHPUT_OVERPROVISIONED
  }
  case object EBSThroughputUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBS_THROUGHPUT_UNDERPROVISIONED
  }
  case object EBSIOPSOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBSIOPS_OVERPROVISIONED
  }
  case object EBSIOPSUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.EBSIOPS_UNDERPROVISIONED
  }
  case object NetworkBandwidthOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_BANDWIDTH_OVERPROVISIONED
  }
  case object NetworkBandwidthUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_BANDWIDTH_UNDERPROVISIONED
  }
  case object NetworkPPSOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_PPS_OVERPROVISIONED
  }
  case object NetworkPPSUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.NETWORK_PPS_UNDERPROVISIONED
  }
  case object DiskIOPSOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_IOPS_OVERPROVISIONED
  }
  case object DiskIOPSUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_IOPS_UNDERPROVISIONED
  }
  case object DiskThroughputOverprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_THROUGHPUT_OVERPROVISIONED
  }
  case object DiskThroughputUnderprovisioned
      extends zio.aws.computeoptimizer.model.InstanceRecommendationFindingReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode =
      software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode.DISK_THROUGHPUT_UNDERPROVISIONED
  }
}
