package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.computeoptimizer.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.JobStatus
  ): zio.aws.computeoptimizer.model.JobStatus = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobStatus.QUEUED =>
      val r = Queued
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobStatus.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.computeoptimizer.model.JobStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobStatus =
      software.amazon.awssdk.services.computeoptimizer.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Queued extends zio.aws.computeoptimizer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobStatus =
      software.amazon.awssdk.services.computeoptimizer.model.JobStatus.QUEUED
  }
  case object InProgress extends zio.aws.computeoptimizer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobStatus =
      software.amazon.awssdk.services.computeoptimizer.model.JobStatus.IN_PROGRESS
  }
  case object Complete extends zio.aws.computeoptimizer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobStatus =
      software.amazon.awssdk.services.computeoptimizer.model.JobStatus.COMPLETE
  }
  case object Failed extends zio.aws.computeoptimizer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.JobStatus =
      software.amazon.awssdk.services.computeoptimizer.model.JobStatus.FAILED
  }
}
