package zio.aws.computeoptimizer.model
import zio.aws.computeoptimizer.model.primitives.{
  LastUpdatedTimestamp,
  StatusReason,
  AccountId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AccountEnrollmentStatus(
    accountId: Optional[AccountId] = Optional.Absent,
    status: Optional[zio.aws.computeoptimizer.model.Status] = Optional.Absent,
    statusReason: Optional[StatusReason] = Optional.Absent,
    lastUpdatedTimestamp: Optional[LastUpdatedTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus = {
    import AccountEnrollmentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        lastUpdatedTimestamp.map(value =>
          LastUpdatedTimestamp.unwrap(value): Instant
        )
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly =
    zio.aws.computeoptimizer.model.AccountEnrollmentStatus.wrap(buildAwsValue())
}
object AccountEnrollmentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.AccountEnrollmentStatus =
      zio.aws.computeoptimizer.model.AccountEnrollmentStatus(
        accountId.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def accountId: Optional[AccountId]
    def status: Optional[zio.aws.computeoptimizer.model.Status]
    def statusReason: Optional[StatusReason]
    def lastUpdatedTimestamp: Optional[LastUpdatedTimestamp]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getStatus: ZIO[Any, AwsError, zio.aws.computeoptimizer.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, LastUpdatedTimestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus
  ) extends zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.computeoptimizer.model.primitives.AccountId(value))
    override val status: Optional[zio.aws.computeoptimizer.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.computeoptimizer.model.Status.wrap(value))
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives.StatusReason(value)
      )
    override val lastUpdatedTimestamp: Optional[LastUpdatedTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.LastUpdatedTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus
  ): zio.aws.computeoptimizer.model.AccountEnrollmentStatus.ReadOnly =
    new Wrapper(impl)
}
