package zio.aws.computeoptimizer.model
import scala.jdk.CollectionConverters._
sealed trait EBSFilterName {
  def unwrap
      : software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName
}
object EBSFilterName {
  def wrap(
      value: software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName
  ): zio.aws.computeoptimizer.model.EBSFilterName = value match {
    case software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName.FINDING =>
      val r = Finding
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.computeoptimizer.model.EBSFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object Finding extends zio.aws.computeoptimizer.model.EBSFilterName {
    override def unwrap
        : software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName =
      software.amazon.awssdk.services.computeoptimizer.model.EBSFilterName.FINDING
  }
}
