package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.computeoptimizer.model.primitives.IncludeMemberAccounts
import scala.jdk.CollectionConverters._
final case class UpdateEnrollmentStatusRequest(
    status: zio.aws.computeoptimizer.model.Status,
    includeMemberAccounts: Optional[IncludeMemberAccounts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest = {
    import UpdateEnrollmentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        includeMemberAccounts.map(value =>
          IncludeMemberAccounts.unwrap(value): java.lang.Boolean
        )
      )(_.includeMemberAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest.ReadOnly =
    zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest
      .wrap(buildAwsValue())
}
object UpdateEnrollmentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest =
      zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest(
        status,
        includeMemberAccounts.map(value => value)
      )
    def status: zio.aws.computeoptimizer.model.Status
    def includeMemberAccounts: Optional[IncludeMemberAccounts]
    def getStatus: ZIO[Any, Nothing, zio.aws.computeoptimizer.model.Status] =
      ZIO.succeed(status)
    def getIncludeMemberAccounts: ZIO[Any, AwsError, IncludeMemberAccounts] =
      AwsError.unwrapOptionField("includeMemberAccounts", includeMemberAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
  ) extends zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest.ReadOnly {
    override val status: zio.aws.computeoptimizer.model.Status =
      zio.aws.computeoptimizer.model.Status.wrap(impl.status())
    override val includeMemberAccounts: Optional[IncludeMemberAccounts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeMemberAccounts())
        .map(value =>
          zio.aws.computeoptimizer.model.primitives.IncludeMemberAccounts(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest
  ): zio.aws.computeoptimizer.model.UpdateEnrollmentStatusRequest.ReadOnly =
    new Wrapper(impl)
}
