package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEffectiveRecommendationPreferencesResponse(
    enhancedInfrastructureMetrics: Option[
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse = {
    import GetEffectiveRecommendationPreferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
      .builder()
      .optionallyWith(enhancedInfrastructureMetrics.map(value => value.unwrap))(
        _.enhancedInfrastructureMetrics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly =
    zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
      .wrap(buildAwsValue())
}
object GetEffectiveRecommendationPreferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse =
      zio.aws.computeoptimizer.model
        .GetEffectiveRecommendationPreferencesResponse(
          enhancedInfrastructureMetrics.map(value => value)
        )
    def enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics]
    def getEnhancedInfrastructureMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
    ] = AwsError.unwrapOptionField(
      "enhancedInfrastructureMetrics",
      enhancedInfrastructureMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ) extends zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly {
    override val enhancedInfrastructureMetrics
        : Option[zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics] =
      scala
        .Option(impl.enhancedInfrastructureMetrics())
        .map(value =>
          zio.aws.computeoptimizer.model.EnhancedInfrastructureMetrics
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
  ): zio.aws.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse.ReadOnly =
    new Wrapper(impl)
}
