package zio.aws.computeoptimizer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.SavingsOpportunityPercentage
import scala.jdk.CollectionConverters._
final case class SavingsOpportunity(
    savingsOpportunityPercentage: Option[SavingsOpportunityPercentage] = None,
    estimatedMonthlySavings: Option[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity = {
    import SavingsOpportunity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity
      .builder()
      .optionallyWith(
        savingsOpportunityPercentage.map(value =>
          SavingsOpportunityPercentage.unwrap(value): java.lang.Double
        )
      )(_.savingsOpportunityPercentage)
      .optionallyWith(
        estimatedMonthlySavings.map(value => value.buildAwsValue())
      )(_.estimatedMonthlySavings)
      .build()
  }
  def asReadOnly: zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly =
    zio.aws.computeoptimizer.model.SavingsOpportunity.wrap(buildAwsValue())
}
object SavingsOpportunity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.computeoptimizer.model.SavingsOpportunity =
      zio.aws.computeoptimizer.model.SavingsOpportunity(
        savingsOpportunityPercentage.map(value => value),
        estimatedMonthlySavings.map(value => value.asEditable)
      )
    def savingsOpportunityPercentage: Option[SavingsOpportunityPercentage]
    def estimatedMonthlySavings: Option[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ]
    def getSavingsOpportunityPercentage
        : ZIO[Any, AwsError, SavingsOpportunityPercentage] =
      AwsError.unwrapOptionField(
        "savingsOpportunityPercentage",
        savingsOpportunityPercentage
      )
    def getEstimatedMonthlySavings: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "estimatedMonthlySavings",
      estimatedMonthlySavings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity
  ) extends zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly {
    override val savingsOpportunityPercentage
        : Option[SavingsOpportunityPercentage] = scala
      .Option(impl.savingsOpportunityPercentage())
      .map(value =>
        zio.aws.computeoptimizer.model.primitives
          .SavingsOpportunityPercentage(value)
      )
    override val estimatedMonthlySavings: Option[
      zio.aws.computeoptimizer.model.EstimatedMonthlySavings.ReadOnly
    ] = scala
      .Option(impl.estimatedMonthlySavings())
      .map(value =>
        zio.aws.computeoptimizer.model.EstimatedMonthlySavings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity
  ): zio.aws.computeoptimizer.model.SavingsOpportunity.ReadOnly = new Wrapper(
    impl
  )
}
