package zio.aws.computeoptimizer.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.computeoptimizer.model.primitives.{
  AccountId,
  MaxResults,
  NextToken,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class GetEc2InstanceRecommendationsRequest(
    instanceArns: Option[Iterable[InstanceArn]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    filters: Option[Iterable[zio.aws.computeoptimizer.model.Filter]] = None,
    accountIds: Option[Iterable[AccountId]] = None,
    recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest = {
    import GetEc2InstanceRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
      .builder()
      .optionallyWith(
        instanceArns.map(value =>
          value.map { item =>
            InstanceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        recommendationPreferences.map(value => value.buildAwsValue())
      )(_.recommendationPreferences)
      .build()
  }
  def asReadOnly
      : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly =
    zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetEc2InstanceRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest =
      zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest(
        instanceArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accountIds.map(value => value),
        recommendationPreferences.map(value => value.asEditable)
      )
    def instanceArns: Option[List[InstanceArn]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def filters: Option[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]]
    def accountIds: Option[List[AccountId]]
    def recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ]
    def getInstanceArns: ZIO[Any, AwsError, List[InstanceArn]] =
      AwsError.unwrapOptionField("instanceArns", instanceArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.computeoptimizer.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getRecommendationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recommendationPreferences",
      recommendationPreferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ) extends zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly {
    override val instanceArns: Option[List[InstanceArn]] = scala
      .Option(impl.instanceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.InstanceArn(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.computeoptimizer.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.computeoptimizer.model.primitives.MaxResults(value))
    override val filters
        : Option[List[zio.aws.computeoptimizer.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.Filter.wrap(item)
        }.toList
      )
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.computeoptimizer.model.primitives.AccountId(item)
        }.toList
      )
    override val recommendationPreferences: Option[
      zio.aws.computeoptimizer.model.RecommendationPreferences.ReadOnly
    ] = scala
      .Option(impl.recommendationPreferences())
      .map(value =>
        zio.aws.computeoptimizer.model.RecommendationPreferences.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest
  ): zio.aws.computeoptimizer.model.GetEc2InstanceRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
